// This file is automatically generated from CSSProperties.json by the process-css-properties.py script. Do not edit it.

#pragma once

#include <array>
#include <wtf/HashFunctions.h>
#include <wtf/HashTraits.h>

namespace WebCore {

class Settings;

enum CSSPropertyID : uint16_t {
    CSSPropertyInvalid = 0,
    CSSPropertyCustom = 1,
    CSSPropertyTestTopPriority = 2,
    CSSPropertyTestHighPriority = 3,
    CSSPropertyTestMediumPriority = 4,
    CSSPropertyBackgroundCoordinatedValueListPropertyTestDiscrete = 5,
    CSSPropertyBackgroundCoordinatedValueListPropertyTestThreeWithConverter = 6,
    CSSPropertyBackgroundCoordinatedValueListPropertyTestTwo = 7,
    CSSPropertyFirstTestDescriptorForFirstDescriptor = 8,
    CSSPropertyFirstTestDescriptorForSecondDescriptor = 9,
    CSSPropertyTestAnimationWrapper = 10,
    CSSPropertyTestAnimationWrapperAccelerationAlways = 11,
    CSSPropertyTestAnimationWrapperAccelerationThreadedOnly = 12,
    CSSPropertyTestBoundedRepetitionWithCommas = 13,
    CSSPropertyTestBoundedRepetitionWithCommasFixed = 14,
    CSSPropertyTestBoundedRepetitionWithCommasNoSingleItemOpt = 15,
    CSSPropertyTestBoundedRepetitionWithCommasSingleItemOpt = 16,
    CSSPropertyTestBoundedRepetitionWithSpaces = 17,
    CSSPropertyTestBoundedRepetitionWithSpacesFixed = 18,
    CSSPropertyTestBoundedRepetitionWithSpacesNoSingleItemOpt = 19,
    CSSPropertyTestBoundedRepetitionWithSpacesSingleItemOpt = 20,
    CSSPropertyTestBoundedRepetitionWithSpacesWithType = 21,
    CSSPropertyTestBoundedRepetitionWithSpacesWithTypeNoSingleItemOpt = 22,
    CSSPropertyTestBoundedRepetitionWithSpacesWithTypeWithDefaultPrevious = 23,
    CSSPropertyTestBoundedRepetitionWithSpacesWithTypeWithDefaultPreviousTwo = 24,
    CSSPropertyTestColor = 25,
    CSSPropertyTestColorAllowsTypesAbsolute = 26,
    CSSPropertyTestColorPropertyWithNoVisitedLinkSupport = 27,
    CSSPropertyTestColorPropertyWithVisitedLinkSupport = 28,
    CSSPropertyTestCustomExtractor = 29,
    CSSPropertyTestExtractorConverter = 30,
    CSSPropertyTestFunctionBoundedParameters = 31,
    CSSPropertyTestFunctionFixedParameters = 32,
    CSSPropertyTestFunctionNoParameters = 33,
    CSSPropertyTestFunctionParametersMatchAllAnyOrder = 34,
    CSSPropertyTestFunctionParametersMatchAllAnyOrderWithOptional = 35,
    CSSPropertyTestFunctionParametersMatchAllOrdered = 36,
    CSSPropertyTestFunctionParametersMatchAllOrderedWithOptional = 37,
    CSSPropertyTestFunctionParametersMatchOneOrMoreAnyOrder = 38,
    CSSPropertyTestFunctionSingleParameter = 39,
    CSSPropertyTestFunctionSingleParameterMatchOne = 40,
    CSSPropertyTestFunctionSingleParameterOptional = 41,
    CSSPropertyTestFunctionUnboundedParametersNoMin = 42,
    CSSPropertyTestFunctionUnboundedParametersWithMinimum = 43,
    CSSPropertyTestImage = 44,
    CSSPropertyTestImageNoImageSet = 45,
    CSSPropertyTestKeyword = 46,
    CSSPropertyTestKeywordWithAliasedTo = 47,
    CSSPropertyTestMatchAllAnyOrder = 48,
    CSSPropertyTestMatchAllAnyOrderWithCustomType = 49,
    CSSPropertyTestMatchAllAnyOrderWithOptional = 50,
    CSSPropertyTestMatchAllAnyOrderWithOptionalAndCustomType = 51,
    CSSPropertyTestMatchAllAnyOrderWithOptionalAndMultipleRequiredAndCustomType = 52,
    CSSPropertyTestMatchAllAnyOrderWithOptionalAndMultipleRequiredAndCustomTypeNoSingleItemOpt = 53,
    CSSPropertyTestMatchAllAnyOrderWithOptionalAndMultipleRequiredAndPreserveOrderAndCustomType = 54,
    CSSPropertyTestMatchAllAnyOrderWithOptionalAndMultipleRequiredAndPreserveOrderAndCustomTypeNoSingleItemOpt = 55,
    CSSPropertyTestMatchAllAnyOrderWithOptionalAndPreserveOrderAndCustomType = 56,
    CSSPropertyTestMatchAllAnyOrderWithOptionalNoSingleItemOpt = 57,
    CSSPropertyTestMatchAllAnyOrderWithOptionalSingleItemOpt = 58,
    CSSPropertyTestMatchAllAnyOrderWithOptionalWithPreserveOrder = 59,
    CSSPropertyTestMatchAllAnyOrderWithOptionalWithPreserveOrderNoSingleItemOpt = 60,
    CSSPropertyTestMatchAllAnyOrderWithPreserveOrder = 61,
    CSSPropertyTestMatchAllAnyOrderWithPreserveOrderAndCustomType = 62,
    CSSPropertyTestMatchAllAnyOrderWithPreserveOrderNoSingleItemOpt = 63,
    CSSPropertyTestMatchAllOrdered = 64,
    CSSPropertyTestMatchAllOrderedWithCustomType = 65,
    CSSPropertyTestMatchAllOrderedWithOptional = 66,
    CSSPropertyTestMatchAllOrderedWithOptionalAndCustomType = 67,
    CSSPropertyTestMatchAllOrderedWithOptionalAndCustomTypeAndNoSingleItemOpt = 68,
    CSSPropertyTestMatchAllOrderedWithOptionalAndMultipleRequired = 69,
    CSSPropertyTestMatchAllOrderedWithOptionalAndMultipleRequiredAndCustomType = 70,
    CSSPropertyTestMatchAllOrderedWithOptionalNoSingleItemOpt = 71,
    CSSPropertyTestMatchAllOrderedWithOptionalSingleItemOpt = 72,
    CSSPropertyTestMatchOne = 73,
    CSSPropertyTestMatchOneOrMoreAnyOrder = 74,
    CSSPropertyTestMatchOneOrMoreAnyOrderNoSingleItemOpt = 75,
    CSSPropertyTestMatchOneOrMoreAnyOrderWithCustomType = 76,
    CSSPropertyTestMatchOneOrMoreAnyOrderWithCustomTypeNoSingleItemOpt = 77,
    CSSPropertyTestMatchOneOrMoreAnyOrderWithPreserveOrder = 78,
    CSSPropertyTestMatchOneOrMoreAnyOrderWithPreserveOrderAndCustomType = 79,
    CSSPropertyTestMatchOneOrMoreAnyOrderWithPreserveOrderAndCustomTypeNoSingleItemOpt = 80,
    CSSPropertyTestMatchOneOrMoreAnyOrderWithPreserveOrderNoSingleItemOpt = 81,
    CSSPropertyTestMatchOneWithGroupWithSettingsFlag = 82,
    CSSPropertyTestMatchOneWithKeywordWithSettingsFlag = 83,
    CSSPropertyTestMatchOneWithMultipleKeywords = 84,
    CSSPropertyTestMatchOneWithReferenceWithSettingsFlag = 85,
    CSSPropertyTestMatchOneWithSettingsFlag = 86,
    CSSPropertyTestNumericValueRange = 87,
    CSSPropertyTestProperty = 88,
    CSSPropertyTestSettingsOne = 89,
    CSSPropertyTestSharedBuilderExtractorConverter = 90,
    CSSPropertyTestUnboundedRepetitionWithCommasWithMin = 91,
    CSSPropertyTestUnboundedRepetitionWithCommasWithMinNoSingleItemOpt = 92,
    CSSPropertyTestUnboundedRepetitionWithCommasWithMinSingleItemOpt = 93,
    CSSPropertyTestUnboundedRepetitionWithSpacesNoMin = 94,
    CSSPropertyTestUnboundedRepetitionWithSpacesNoMinNoSingleItemOpt = 95,
    CSSPropertyTestUnboundedRepetitionWithSpacesWithMin = 96,
    CSSPropertyTestUnboundedRepetitionWithSpacesWithMinNoSingleItemOpt = 97,
    CSSPropertyTestUnboundedRepetitionWithSpacesWithMinSingleItemOpt = 98,
    CSSPropertyTestUrlWithModifiers = 99,
    CSSPropertyTestUrlWithNoModifiers = 100,
    CSSPropertyTestUsingSharedRule = 101,
    CSSPropertyTestUsingSharedRuleExported = 102,
    CSSPropertyTestUsingSharedRuleWithOverrideFunction = 103,
    CSSPropertyTestSinkPriority = 104,
    CSSPropertyTestLogicalPropertyGroupPhysicalHorizontal = 105,
    CSSPropertyTestLogicalPropertyGroupPhysicalVertical = 106,
    CSSPropertyTestLogicalPropertyGroupLogicalBlock = 107,
    CSSPropertyTestLogicalPropertyGroupLogicalInline = 108,
    CSSPropertyAll = 109,
    CSSPropertyFont = 110,
    CSSPropertyTestShorthandOne = 111,
    CSSPropertyTestShorthandTwo = 112,
};

// Enum value of the first "real" CSS property, which excludes
// CSSPropertyInvalid and CSSPropertyCustom.
constexpr uint16_t firstCSSProperty = 2;
// Total number of enum values in the CSSPropertyID enum. If making an array
// that can be indexed into using the enum value, use this as the size.
constexpr uint16_t cssPropertyIDEnumValueCount = 113;
// Number of "real" CSS properties. This differs from cssPropertyIDEnumValueCount,
// as this doesn't consider CSSPropertyInvalid and CSSPropertyCustom.
constexpr uint16_t numCSSProperties = 111;
constexpr unsigned maxCSSPropertyNameLength = 114;
constexpr auto firstTopPriorityProperty = CSSPropertyID::CSSPropertyTestTopPriority;
constexpr auto lastTopPriorityProperty = CSSPropertyID::CSSPropertyTestTopPriority;
constexpr auto firstHighPriorityProperty = CSSPropertyID::CSSPropertyTestHighPriority;
constexpr auto lastHighPriorityProperty = CSSPropertyID::CSSPropertyTestHighPriority;
constexpr auto firstMediumPriorityProperty = CSSPropertyID::CSSPropertyTestMediumPriority;
constexpr auto lastMediumPriorityProperty = CSSPropertyID::CSSPropertyTestMediumPriority;
constexpr auto firstLowPriorityProperty = CSSPropertyID::CSSPropertyBackgroundCoordinatedValueListPropertyTestDiscrete;
constexpr auto lastLowPriorityProperty = CSSPropertyID::CSSPropertyTestSinkPriority;
constexpr auto firstLogicalGroupPhysicalProperty = CSSPropertyID::CSSPropertyTestLogicalPropertyGroupPhysicalHorizontal;
constexpr auto lastLogicalGroupPhysicalProperty = CSSPropertyID::CSSPropertyTestLogicalPropertyGroupPhysicalVertical;
constexpr auto firstLogicalGroupLogicalProperty = CSSPropertyID::CSSPropertyTestLogicalPropertyGroupLogicalBlock;
constexpr auto lastLogicalGroupLogicalProperty = CSSPropertyID::CSSPropertyTestLogicalPropertyGroupLogicalInline;
constexpr auto firstLogicalGroupProperty = firstLogicalGroupPhysicalProperty;
constexpr auto lastLogicalGroupProperty = lastLogicalGroupLogicalProperty;
constexpr auto firstShorthandProperty = CSSPropertyID::CSSPropertyAll;
constexpr auto lastShorthandProperty = CSSPropertyID::CSSPropertyTestShorthandTwo;
constexpr uint16_t numCSSPropertyLonghands = firstShorthandProperty - firstCSSProperty;

extern const std::array<CSSPropertyID, 105> computedPropertyIDs;

template<CSSPropertyID C> struct PropertyNameConstant {
    static constexpr auto value = C;
    constexpr bool operator==(const PropertyNameConstant&) const = default;
    constexpr bool operator==(CSSPropertyID other) const { return value == other; }
};

struct CSSPropertySettings {
    WTF_DEPRECATED_MAKE_STRUCT_FAST_ALLOCATED(CSSPropertySettings);

    bool cssDescriptorEnabled : 1 { false };
    bool cssSettingsOneEnabled : 1 { false };
    bool cssSettingsShorthandEnabled : 1 { false };

    CSSPropertySettings() = default;
    explicit CSSPropertySettings(const Settings&);
};

bool operator==(const CSSPropertySettings&, const CSSPropertySettings&);
void add(Hasher&, const CSSPropertySettings&);

constexpr bool isLonghand(CSSPropertyID);
bool isInternal(CSSPropertyID);
bool isExposed(CSSPropertyID, const Settings*);
bool isExposed(CSSPropertyID, const Settings&);
bool isExposed(CSSPropertyID, const CSSPropertySettings*);
bool isExposed(CSSPropertyID, const CSSPropertySettings&);

CSSPropertyID findCSSProperty(const char* characters, unsigned length);
ASCIILiteral nameLiteral(CSSPropertyID);
const AtomString& nameString(CSSPropertyID);
String nameForIDL(CSSPropertyID);

CSSPropertyID cascadeAliasProperty(CSSPropertyID);

template<CSSPropertyID first, CSSPropertyID last> struct CSSPropertiesRange {
    struct Iterator {
        uint16_t index { static_cast<uint16_t>(first) };
        constexpr CSSPropertyID operator*() const { return static_cast<CSSPropertyID>(index); }
        constexpr Iterator& operator++() { ++index; return *this; }
        constexpr bool operator==(std::nullptr_t) const { return index > static_cast<uint16_t>(last); }
    };
    static constexpr Iterator begin() { return { }; }
    static constexpr std::nullptr_t end() { return nullptr; }
    static constexpr uint16_t size() { return last - first + 1; }
};
using AllCSSPropertiesRange = CSSPropertiesRange<static_cast<CSSPropertyID>(firstCSSProperty), lastShorthandProperty>;
using AllLonghandCSSPropertiesRange = CSSPropertiesRange<static_cast<CSSPropertyID>(firstCSSProperty), lastLogicalGroupProperty>;
constexpr AllCSSPropertiesRange allCSSProperties() { return { }; }
constexpr AllLonghandCSSPropertiesRange allLonghandCSSProperties() { return { }; }

constexpr bool isLonghand(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= firstCSSProperty
        && static_cast<uint16_t>(property) < static_cast<uint16_t>(firstShorthandProperty);
}
constexpr bool isShorthand(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= static_cast<uint16_t>(firstShorthandProperty)
        && static_cast<uint16_t>(property) <= static_cast<uint16_t>(lastShorthandProperty);
}

constexpr bool isLogicalPropertyGroupProperty(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= static_cast<uint16_t>(firstLogicalGroupPhysicalProperty)
        && static_cast<uint16_t>(property) <= static_cast<uint16_t>(lastLogicalGroupLogicalProperty);
}

constexpr bool isLogicalPropertyGroupPhysicalProperty(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= static_cast<uint16_t>(firstLogicalGroupPhysicalProperty)
        && static_cast<uint16_t>(property) <= static_cast<uint16_t>(lastLogicalGroupPhysicalProperty);
}

constexpr bool isLogicalPropertyGroupLogicalProperty(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= static_cast<uint16_t>(firstLogicalGroupLogicalProperty)
        && static_cast<uint16_t>(property) <= static_cast<uint16_t>(lastLogicalGroupLogicalProperty);
}

WTF::TextStream& operator<<(WTF::TextStream&, CSSPropertyID);

} // namespace WebCore

namespace WTF {

template<> struct DefaultHash<WebCore::CSSPropertyID> : IntHash<unsigned> { };

template<> struct HashTraits<WebCore::CSSPropertyID> : GenericHashTraits<WebCore::CSSPropertyID> {
    static const bool emptyValueIsZero = true;
    static void constructDeletedValue(WebCore::CSSPropertyID& slot) { slot = static_cast<WebCore::CSSPropertyID>(std::numeric_limits<uint16_t>::max()); }
    static bool isDeletedValue(WebCore::CSSPropertyID value) { return static_cast<uint16_t>(value) == std::numeric_limits<uint16_t>::max(); }
};

} // namespace WTF

namespace std {

template<> struct iterator_traits<WebCore::AllCSSPropertiesRange::Iterator> { using value_type = WebCore::CSSPropertyID; };
template<> struct iterator_traits<WebCore::AllLonghandCSSPropertiesRange::Iterator> { using value_type = WebCore::CSSPropertyID; };

} // namespace std

