---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, pages, tourner, pivoter, format paysage, 
              format à l'italienne, format allongé, rotation des pages
---

# Comment changer l'orientation de tout ou partie d'un document ?

Il est souvent nécessaire de composer tout ou partie d'un document 
en orientation [paysage](wpfr:Mode_paysage)  (ou "format à l'italienne", 
par opposition à l'orientation [portrait](wpfr:Mode_portrait) ou 
"format à la française").

Pour y parvenir, il faut non seulement changer les dimensions de la page, 
mais aussi demander au périphérique de sortie d'imprimer différemment 
cette page particulière. Plusieurs solutions existent, classée ici 
selon l'amplitude souhaitée de cette modification.


## Pour l'ensemble d'un document

### Avec l'extension <ctanpkg:geometry>

L'extension <ctanpkg:geometry>, de Hideo Umeki et David Carlisle, 
est considérée comme une référence sur le sujet de la définition 
de la géométrie des pages d'un document.

Son option `landscape` permet d'obtenir cette orientation. 
Si vous passez aussi l'option `dvips` ou `pdftex` à l'extension, 
elle génère également les instructions de rotation pour que la sortie 
soit correctement orientée.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage[landscape]{geometry}

\begin{document}
Voici un document écrit dans un sens non usuel.
\end{document}
```


### Avec la classe <ctanpkg:memoir>

La classe <ctanpkg:memoir> a les mêmes fonctionnalités que 
<ctanpkg:geometry>.


### Avec les classes standards

:::{warning}
Cette solution n'est indiquée que pour en présenter les limites.
:::

Les classes standards proposent une option `landscape` 
pour la commande `\documentclass`. Cependant, cette option 
ne change que les réglages de la zone de texte, pas 
*le format de la page* ! L'exemple suivant montre un PDF toujours 
en format portrait et le texte se comporte dans une zone 
au format paysage.

```
\documentclass[landscape,french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Voici un document écrit dans un sens non usuel.
\end{document}
```

Cette demi-solution ne sera sans doute pas satisfaisante 
et vous demandera de modifier la géométrie de la page.


### Avec le programme DVIPS

Dans le cas où vous auriez un fichier DVI en format paysage, 
vous pouvez obtenir un fichier PostScript propre en utilisant
la commande :

```bash
dvips -t a4 -t landscape -o tmp.ps toto.dvi
```


### Avec le programme DocStrip

Le programme [DocStrip](ctanpkg:docstrip) pourrait le faire, 
bien que ce ne soit pas son but premier.

:::{todo} À développer.
:::


## Pour une partie d'un document

### Avec les extensions <ctanpkg:lscape> ou <ctanpkg:pdflscape>

Si vous avez une longue séquence d'éléments qui doivent être placés
en orientation paysage (une liste de codes, un large environnement 
`tabbing`, ou une énorme table composée avec <ctanpkg:longtable> 
ou <ctanpkg:supertabular>), utilisez alors :

- l'extension <ctanpkg:lscape> de David Carlisle ;
- si vous générez un document PDF avec `pdflatex` ou `dvips` 
  puis `ps2pdf`, l'extension <ctanpkg:pdflscape>.

Dans les deux cas, vous disposerez alors d'un environnement 
`landscape` : il efface la page courante et la compose 
en orientation paysage ; lors de sa clôture, il efface 
la page courante avant de revenir à une composition en orientation 
portrait. En voici un exemple d'utilisation :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{lscape}

\begin{document}
\begin{landscape}
  Un petit tour à la campagne...
\end{landscape}
et nous voici de retour dans la galerie, après
un  changement de page bien évidemment.
\end{document}
```

## Pour une partie de page

Si les solutions présentées par la suite permette d'avoir 
un élément en orientation paysage (par rotation), aucune extension
actuellement disponible ne prévoit directement la composition 
en orientation portrait et paysage sur la même page : 
TeX n'est pas pensé pour le faire. 

Si un tel comportement était une nécessité absolue, 
on pourrait utiliser les techniques décrites dans la question 
"[](/3_composition/flottants/habiller_une_image_avec_du_texte)", 
et faire pivoter la partie à mettre en orientation paysage 
en utilisant les fonctions de rotation de l'extension 
<ctanpkg:graphicx>. Le retour à l'orientation portrait serait 
un peu plus facile : la partie portrait de la page serait 
un flottant de bas de page à la fin de la section paysage, 
avec son contenu pivoté.

:::{todo} Un exemple pourrait être intéressant pour illustrer 
ce point.
:::

### Avec l'extension <ctanpkg:rotating>

Si vous avez un seul objet flottant qui ne peut rentrer sur la page
qu'en orientation paysage, utilisez l'extension <ctanpkg:rotating>. 
Elle définit les environnements `sidewaysfigure` et `sidewaystable` 
qui créent des flottants qui occupent une page entière.
Pour les mises en page à deux colonnes, utiliser la version étoilée
de ces environnements.

Notez que <ctanpkg:rotating> pose problème dans des documents 
qui chargent également l'extension <ctanpkg:float> (souvent 
recommandée dans cette FAQ, par exemple à la question 
"[](/3_composition/flottants/pourquoi_faire_flotter_ses_figures_et_tableaux)"). 
L'extension <ctanpkg:rotfloat> charge <ctanpkg:rotating> 
et fluidifie l'interaction avec <ctanpkg:float> en permettant 
de déclarer des environnements pivotés.

L'extension <ctanpkg:rotating> propose d'autres environnements 
pour pivoter des contenus qui ne sont pas des flottants :
`sideways` pour pivoter de 90 degrés dans le sens trigonométrique 
et `turn` et `rotate` qui permettent de spécifier n'importe quel angle
(`rotate` n'introduit pas d'espace supplémentaire). L'exemple suivant
 montre un usage un peu alambiqué de `rotate` où l'on voit 
 l'intérêt de ne pas introduire d'espace supplémentaire :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{rotating}

  \newcount\angleroue
  \newsavebox{\texteroue}
  \newdimen\espaceroue

  \def\roue#1{%
    \savebox{\texteroue}{#1}%
    \espaceroue\wd\texteroue
    \advance\espaceroue by 1cm%
    \centerline{%
      \rule{0pt}{\espaceroue}%
      \rule[-\espaceroue]{0pt}{\espaceroue}%
      \angleroue=-180
      \loop\ifnum\angleroue<180
        \rlap{%
          \begin{rotate}{\the\angleroue}%
            \rule{1cm}{0pt}#1%
          \end{rotate}%
        }%
        \advance\angleroue by 10
      \repeat
    }%
  }

\begin{document}
\roue{Sol lucet omnibus}
\end{document}
```

Notez que la plupart des prévisualisateurs TeX actuels 
ne respectent pas les demandes de rotation dans les fichiers DVI. 
Le mieux est de convertir votre sortie en PostScript ou en PDF 
pour obtenir la présentation souhaitée.


:::{sources}
[Typesetting things in landscape orientation](faquk:FAQ-landscape)
:::