Attempted to index a value whose type doesn't implement the
`std::ops::Index` trait.

Erroneous code example:

```compile_fail,E0608
0u8[2]; // error: cannot index into a value of type `u8`
```

Only values with types that implement the `std::ops::Index` trait
can be indexed with square brackets. Example:

```
let v: Vec<u8> = vec![0, 1, 2, 3];

// The `Vec` type implements the `Index` trait so you can do:
println!("{}", v[2]);
```

Tuples and structs are indexed with dot (`.`), not with brackets (`[]`),
and tuple element names are their positions:
```ignore(pseudo code)
// this (pseudo code) expression is true for any tuple:
tuple == (tuple.0, tuple.1, ...)
```
