<!-- markdownlint-disable first-line-h1 -->
### Deprecations and warnings

#### HIP Perl scripts deprecation

The `hipcc` and `hipconfig` Perl scripts are deprecated. In a future release, compiled binaries will be
available as `hipcc.bin` and `hipconfig.bin` as replacements for the Perl scripts.

:::{note}
There will be a transition period where the Perl scripts and compiled binaries are available before the
scripts are removed. There will be no functional difference between the Perl scripts and their compiled
binary counterpart. No user action is required. Once these are available, users can optionally switch to
`hipcc.bin` and `hipconfig.bin`. The `hipcc`/`hipconfig` soft link will be assimilated to point from
`hipcc`/`hipconfig` to the respective compiled binaries as the default option.
:::

##### Linux file system hierarchy standard for ROCm

ROCm packages have adopted the Linux foundation file system hierarchy standard in this release to
ensure ROCm components follow open source conventions for Linux-based distributions. While
moving to a new file system hierarchy, ROCm ensures backward compatibility with its 5.1 version or
older file system hierarchy. See below for a detailed explanation of the new file system hierarchy and
backward compatibility.

##### New file system hierarchy

The following is the new file system hierarchy:4

```text
/opt/rocm-<ver>
    | --bin
      | --All externally exposed Binaries
    | --libexec
        | --<component>
            | -- Component specific private non-ISA executables (architecture independent)
    | --include
        | -- <component>
            | --<header files>
    | --lib
        | --lib<soname>.so -> lib<soname>.so.major -> lib<soname>.so.major.minor.patch
            (public libraries linked with application)
        | --<component> (component specific private library, executable data)
        | --<cmake>
            | --components
                | --<component>.config.cmake
    | --share
        | --html/<component>/*.html
        | --info/<component>/*.[pdf, md, txt]
        | --man
        | --doc
            | --<component>
                | --<licenses>
        | --<component>
            | --<misc files> (arch independent non-executable)
            | --samples

```

:::{note}
ROCm will not support backward compatibility with the v5.1(old) file system hierarchy in its next major
release.
:::

For more information, refer to <https://refspecs.linuxfoundation.org/fhs.shtml>.

##### Backward compatibility with older file systems

ROCm has moved header files and libraries to its new location as indicated in the above structure and
included symbolic-link and wrapper header files in its old location for backward compatibility.

:::{note}
ROCm will continue supporting backward compatibility until the next major release.
:::

##### Wrapper header files

Wrapper header files are placed in the old location (`/opt/rocm-xxx/<component>/include`) with a
warning message to include files from the new location (`/opt/rocm-xxx/include`) as shown in the
example below:

```cpp
// Code snippet from hip_runtime.h
#pragma message “This file is deprecated. Use file from include path /opt/rocm-ver/include/ and prefix with hip”.
#include "hip/hip_runtime.h"
```

The wrapper header files’ backward compatibility deprecation is as follows:

* `#pragma` message announcing deprecation -- ROCm v5.2 release
* `#pragma` message changed to `#warning` -- Future release
* `#warning` changed to `#error` -- Future release
* Backward compatibility wrappers removed -- Future release

##### Library files

Library files are available in the `/opt/rocm-xxx/lib` folder. For backward compatibility, the old library
location (`/opt/rocm-xxx/<component>/lib`) has a soft link to the library at the new location.

Example:

```bash
$ ls -l /opt/rocm/hip/lib/
total 4
drwxr-xr-x 4 root root 4096 May 12 10:45 cmake
lrwxrwxrwx 1 root root   24 May 10 23:32 libamdhip64.so -> ../../lib/libamdhip64.so
```

##### CMake config files

All CMake configuration files are available in the `/opt/rocm-xxx/lib/cmake/<component>` folder. For
backward compatibility, the old CMake locations (`/opt/rocm-xxx/<component>/lib/cmake`) consist of
a soft link to the new CMake config.

Example:

```bash
$ ls -l /opt/rocm/hip/lib/cmake/hip/
total 0
lrwxrwxrwx 1 root root 42 May 10 23:32 hip-config.cmake -> ../../../../lib/cmake/hip/hip-config.cmake
```

### Defect fixes

#### Compiler improvements

In ROCm v5.4.3, improvements to the compiler address errors with the following signatures:

* "error: unhandled SGPR spill to memory"
* "cannot scavenge register without an emergency spill slot!"
* "error: ran out of registers during register allocation"

### Known issues

#### Compiler option error at runtime

Some users may encounter a “Cannot find Symbol” error at runtime when using `-save-temps`. While
most `-save-temps` use cases work correctly, this error may appear occasionally.

This issue is under investigation, and the known workaround is not to use `-save-temps` when the error
appears.
