% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shape_text.R
\name{plot_shape}
\alias{plot_shape}
\title{Preview shaped text and the metrics for the text box}
\usage{
plot_shape(shape, id = 1)
}
\arguments{
\item{shape}{The output of a call to \code{\link[=shape_text]{shape_text()}}}

\item{id}{The index of the text run to show in case \code{shape} contains
multiples}
}
\value{
This function is called for its side effects
}
\description{
This function allows you to preview the layout that \code{\link[=shape_text]{shape_text()}}
calculates. It is purely meant as a sanity check to make sure that the values
calculated are sensible and shouldn't be used as a plotting function for
rendering text on its own.
}
\examples{
arab_text <- lorem_text("arabic", 2)
shape <- shape_text(
  arab_text,
  max_width = 5,
  indent = 0.2
)

try(
 plot_shape(shape)
)

}
