% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step.R
\name{plot.step_list}
\alias{plot.step_list}
\title{Plot LS-means for Backward Reduced Model}
\usage{
\method{plot}{step_list}(
  x,
  y = NULL,
  which = NULL,
  pairwise = FALSE,
  mult = TRUE,
  level = 0.95,
  ddf = c("Satterthwaite", "Kenward-Roger"),
  ...
)
}
\arguments{
\item{x}{a \code{step_list} object; the result of running
\code{\link[=step.lmerModLmerTest]{step}}.}

\item{y}{not used and ignored with a warning.}

\item{which}{optional character vector naming factors for which LS-means should
be plotted. If \code{NULL} (default) plots for all LS-means are generated.}

\item{pairwise}{pairwise differences of LS-means?}

\item{mult}{if \code{TRUE} and there is more than one term for which to plot
LS-means the plots are organized in panels with \code{facet_wrap}.}

\item{level}{confidence level.}

\item{ddf}{denominator degree of freedom method.}

\item{...}{currently not used.}
}
\description{
Computes the LS-means for the final backward reduced model and passes these
to \code{\link{plot.ls_means}}.
}
\details{
Error bars are confidence intervals - the default is 95% CI but the confidence
level can be changed.
}
\examples{

\dontrun{
# Fit example model:
tv <- lmer(Sharpnessofmovement ~ TVset * Picture +
             (1 | Assessor:TVset) + (1 | Assessor:Picture) +
             (1 | Assessor:Picture:TVset) + (1 | Repeat) + (1 | Repeat:Picture) +
             (1 | Repeat:TVset) + (1 | Repeat:TVset:Picture) + (1 | Assessor),
           data = TVbo)

# Backward reduce the model:
(st <- step(tv)) # takes ~10 sec to run

# Pairwise comparisons of LS-means for Picture and TVset:
  plot(st, which=c("Picture", "TVset"), pairwise = TRUE)
}

}
\seealso{
\code{\link[=ls_means.lmerModLmerTest]{ls_means}} and
\code{\link{plot.ls_means}}
}
\author{
Rune Haubo B. Christensen and Alexandra Kuznetsova
}
\keyword{internal}
