% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compact_summary.R
\name{as_flextable.compact_summary}
\alias{as_flextable.compact_summary}
\title{Transform a 'compact_summary' object into a flextable}
\usage{
\method{as_flextable}{compact_summary}(x, ...)
}
\arguments{
\item{x}{A \code{compact_summary} object produced by
\code{\link[=compact_summary]{compact_summary()}}.}

\item{...}{unused arguments.}
}
\value{
A \code{\link[=flextable]{flextable()}} object.
}
\description{
\code{compact_summary} objects can be transformed into
a flextable with method \code{\link[=as_flextable]{as_flextable()}}.

Numeric columns are formatted with \code{\link[=formatC]{formatC()}} using the
\code{digits} value stored in the object and the current
flextable defaults for \code{big.mark} and \code{decimal.mark}.
}
\examples{
z <- compact_summary(iris, show_type = TRUE, show_na = TRUE)
as_flextable(z)
}
\seealso{
Other as_flextable methods: 
\code{\link{as_flextable}()},
\code{\link{as_flextable.data.frame}()},
\code{\link{as_flextable.gam}()},
\code{\link{as_flextable.glm}()},
\code{\link{as_flextable.grouped_data}()},
\code{\link{as_flextable.htest}()},
\code{\link{as_flextable.kmeans}()},
\code{\link{as_flextable.lm}()},
\code{\link{as_flextable.merMod}()},
\code{\link{as_flextable.pam}()},
\code{\link{as_flextable.summarizor}()},
\code{\link{as_flextable.table}()},
\code{\link{as_flextable.tabular}()},
\code{\link{as_flextable.tabulator}()},
\code{\link{as_flextable.xtable}()},
\code{\link{compact_summary}()}
}
\concept{as_flextable methods}
