% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errors-children.R
\name{Error-Classes}
\alias{Error-Classes}
\alias{HTTPContinue}
\alias{HTTPSwitchProtocol}
\alias{HTTPProcessing}
\alias{HTTPOK}
\alias{HTTPCreated}
\alias{HTTPAccepted}
\alias{HTTPNonAuthoritativeInformation}
\alias{HTTPNoContent}
\alias{HTTPResetContent}
\alias{HTTPPartialContent}
\alias{HTTPMultiStatus}
\alias{HTTPAlreadyReported}
\alias{HTTPImUsed}
\alias{HTTPMultipleChoices}
\alias{HTTPMovedPermanently}
\alias{HTTPFound}
\alias{HTTPSeeOther}
\alias{HTTPNotModified}
\alias{HTTPUseProxy}
\alias{HTTPSwitchProxy}
\alias{HTTPTemporaryRedirect}
\alias{HTTPPermanentRedirect}
\alias{HTTPBadRequest}
\alias{HTTPUnauthorized}
\alias{HTTPPaymentRequired}
\alias{HTTPForbidden}
\alias{HTTPNotFound}
\alias{HTTPMethodNotAllowed}
\alias{HTTPNotAcceptable}
\alias{HTTPProxyAuthenticationRequired}
\alias{HTTPRequestTimeout}
\alias{HTTPConflict}
\alias{HTTPGone}
\alias{HTTPLengthRequired}
\alias{HTTPPreconditionFailed}
\alias{HTTPRequestEntityTooLarge}
\alias{HTTPRequestURITooLong}
\alias{HTTPUnsupportedMediaType}
\alias{HTTPRequestRangeNotSatisfiable}
\alias{HTTPExpectationFailed}
\alias{HTTPTeaPot}
\alias{HTTPAuthenticationTimeout}
\alias{HTTPMethodFailure}
\alias{HTTPMisdirectedRequest}
\alias{HTTPUnprocessableEntity}
\alias{HTTPLocked}
\alias{HTTPFailedDependency}
\alias{HTTPUnorderedCollection}
\alias{HTTPUpgradeRequired}
\alias{HTTPPreconditionRequired}
\alias{HTTPTooManyRequests}
\alias{HTTPRequestHeaderFieldsTooLarge}
\alias{HTTPLoginTimeout}
\alias{HTTPNoResponse}
\alias{HTTPRetryWith}
\alias{HTTPBlockedByWindowsParentalControls}
\alias{HTTPUnavailableForLegalReasons}
\alias{HTTPRequestHeaderTooLarge}
\alias{HTTPCertError}
\alias{HTTPNoCert}
\alias{HTTPHTTPToHTTPS}
\alias{HTTPTokenExpiredInvalid}
\alias{HTTPClientClosedRequest}
\alias{HTTPInternalServerError}
\alias{HTTPNotImplemented}
\alias{HTTPBadGateway}
\alias{HTTPServiceUnavailable}
\alias{HTTPGatewayTimeout}
\alias{HTTPHTTPVersionNotSupported}
\alias{HTTPVariantAlsoNegotiates}
\alias{HTTPInsufficientStorage}
\alias{HTTPLoopDetected}
\alias{HTTPBandwidthLimitExceeded}
\alias{HTTPNotExtended}
\alias{HTTPNetworkAuthenticationRequired}
\alias{HTTPNetworkReadTimeoutError}
\alias{HTTPNetworkConnectTimeoutError}
\alias{HTTPWebServerReturnedUnknownError}
\alias{HTTPWebServerIsDown}
\alias{HTTPConnectionTimedOut}
\alias{HTTPOriginIsUnreachable}
\alias{HTTPATimeoutOccurred}
\alias{HTTPSSLHandshakeFailed}
\alias{HTTPInvalidSSLCertificate}
\alias{HTTPRailgunError}
\title{Individual error classes}
\description{
These error classes are for each HTTP error, and inherit from
the \link{Error} class in this package.
}
\details{
In addition to what's available in \link{Error},
these classes have a single variable \code{mssg} that is the very
verbose complete message describing the HTTP condition in detail.
You can include that message in your condition by using \code{do_verbose}
(see below)
}
\section{Methods}{


In addition to the methods documented in \link{Error}, these classes
also have:
\itemize{
\item \code{do_verbose(response, template)}:

Execute condition, whether it be message, warning, or error.
\itemize{
\item response: is any response from \code{crul}, \code{curl}, or \code{httr}
Execute condition, whether it be message, warning, error, or your
own custom function. This method uses \code{message_template_verbose},
and uses it's default value.
\item template: a template to use for the verbose message, see \link{Error}
for details
}
}
}

\examples{
HTTPRequestURITooLong$new(
  message_template = "{{reason}} ............ {{status}}",
  message_template_verbose = "{{reason}} .>.>.>.>.>.> {{status}}\n {{message}}"
)
}
\seealso{
\link{Error}, \link{http}
}
