---
title: QCoro 0.9.0 Release Announcement
date: "2023-04-27"
description: >
  Important bugfixes, huge improvement to QML support and a brand new Test module.
---

<!--
SPDX-FileCopyrightText: 2023 Daniel Vrátil <dvratil@kde.org>

SPDX-License-Identifier: GFDL-1.3-or-later
-->

# QCoro 0.9.0 Release Announcement

Another smallish release with just a few new features, but quite important bugfixes.

As always, thank you to everyone who reported issues and contributed to QCoro.
Your help is much appreciated!

## Enhanced QML Support

Jonah Brüchert has improved the QML support by introducing a declarative API to await
a task result.

Previously a task result could have only been obtained inside a JavaScript function:

```qml
Label {
    id: usernameLabel
    Component.onCompleted: {
        api.getUserName().then(function(result) {
            usernameLabel.text = result
        })
    }
}
```

With QCoro 0.9.0 you can use the new declarative API to use the result of an asynchronous
task in a property binding:

```qml
Label {
    id: usernameLabel
    text: api.getUserName().await("Loading...").value
}
```

The `Label` will now show the string "Loading..." while the asynchronous task is running
and will automatically change to the result of the task once if finishes.

You can check the [`QCoro::QmlTask` documentation][qcoro-qmltask-docs] for more details.

## QCoroTest Module

Yet another release with a new QCoro module! This time it's for tests! The QCoroTest
module contains macros (e.g., `QCORO_VERIFY`, `QCORO_COMPARE`, ...) that are basically
identical to their QtTest counteparts with the only difference being that they can be 
used inside a coroutine.

We already had this macros inside QCoro test suite almost since the very beginning
and realized they can be useful to our users as well, since they will likely want
to have unittests for their coroutine code.

In some of the next releases we would like to add a little bit more infrastructure
to make writing unittests for coroutines with QtTest even easier.

Check the [`QCoroTest` module documentation][qcoro-test-docs] with a full list of
the test macros.

## Full changelog

[See changelog on Github](https://github.com/danvratil/qcoro/releases/tag/v0.9.0)

[qcoro-qmltask-docs]: https://qcoro.dvratil.cz/reference/qml/qmltask/
[qcoro-test-docs]: https://qcoro.dvratil.cz/reference/test/

