# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.applicationinsights.aio import ApplicationInsightsManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestApplicationInsightsManagementFavoritesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ApplicationInsightsManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_favorites_list(self, resource_group):
        response = await self.client.favorites.list(
            resource_group_name=resource_group.name,
            resource_name="str",
            api_version="2015-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_favorites_get(self, resource_group):
        response = await self.client.favorites.get(
            resource_group_name=resource_group.name,
            resource_name="str",
            favorite_id="str",
            api_version="2015-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_favorites_add(self, resource_group):
        response = await self.client.favorites.add(
            resource_group_name=resource_group.name,
            resource_name="str",
            favorite_id="str",
            favorite_properties={
                "Category": "str",
                "Config": "str",
                "FavoriteId": "str",
                "FavoriteType": "str",
                "IsGeneratedFromTemplate": bool,
                "Name": "str",
                "SourceType": "str",
                "Tags": ["str"],
                "TimeModified": "str",
                "UserId": "str",
                "Version": "str",
            },
            api_version="2015-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_favorites_update(self, resource_group):
        response = await self.client.favorites.update(
            resource_group_name=resource_group.name,
            resource_name="str",
            favorite_id="str",
            favorite_properties={
                "Category": "str",
                "Config": "str",
                "FavoriteId": "str",
                "FavoriteType": "str",
                "IsGeneratedFromTemplate": bool,
                "Name": "str",
                "SourceType": "str",
                "Tags": ["str"],
                "TimeModified": "str",
                "UserId": "str",
                "Version": "str",
            },
            api_version="2015-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_favorites_delete(self, resource_group):
        response = await self.client.favorites.delete(
            resource_group_name=resource_group.name,
            resource_name="str",
            favorite_id="str",
            api_version="2015-05-01",
        )

        # please add some check logic here by yourself
        # ...
