// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef AVTTENSORMETADATA_H
#define AVTTENSORMETADATA_H
#include <dbatts_exports.h>
#include <avtVarMetaData.h>


// ****************************************************************************
// Class: avtTensorMetaData
//
// Purpose:
//    Contains tensor metadata attributes
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class DBATTS_API avtTensorMetaData : public avtVarMetaData
{
public:
    // These constructors are for objects of this class
    avtTensorMetaData();
    avtTensorMetaData(const avtTensorMetaData &obj);
protected:
    // These constructors are for objects derived from this class
    avtTensorMetaData(private_tmfs_t tmfs);
    avtTensorMetaData(const avtTensorMetaData &obj, private_tmfs_t tmfs);
public:
    virtual ~avtTensorMetaData();

    virtual avtTensorMetaData& operator = (const avtTensorMetaData &obj);
    virtual bool operator == (const avtTensorMetaData &obj) const;
    virtual bool operator != (const avtTensorMetaData &obj) const;
private:
    void Init();
    void Copy(const avtTensorMetaData &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    avtTensorMetaData(std::string, std::string, avtCentering, int);
    void Print(ostream &, int = 0) const;

    // IDs that can be used to identify fields in case statements
    enum {
        ID_dim = avtVarMetaData::ID__LAST,
        ID__LAST
    };

public:
    int dim;

private:
    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define AVTTENSORMETADATA_TMFS AVTVARMETADATA_TMFS "i"

#endif
