#pragma once

/*
 * machinarium.
 *
 * cooperative multitasking engine.
 */

#include <stddef.h>

#include <machinarium/build.h>

typedef struct mm_contextstack mm_contextstack_t;

struct mm_contextstack {
	char *pointer;
	size_t size;
	size_t size_guard;
#ifdef HAVE_VALGRIND
	int valgrind_stack;
#endif
};

int mm_contextstack_create(mm_contextstack_t *, size_t, size_t);
void mm_contextstack_free(mm_contextstack_t *);
