/* $Id: Scaled_int_multi_data.cpp 457991 2015-01-29 19:26:03Z vasilche $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'seqtable.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>

// generated includes
#include <objects/seqtable/Scaled_int_multi_data.hpp>

#include <objects/seqtable/SeqTable_multi_data.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CScaled_int_multi_data::~CScaled_int_multi_data(void)
{
}


size_t CScaled_int_multi_data::GetIntSize(void) const
{
    if ( (IsSetMax() && GetMax() > kMax_Int) ||
         (IsSetMin() && GetMin() < kMin_Int) ) {
        return sizeof(Int8);
    }
    return sizeof(int);
}


bool CScaled_int_multi_data::TryGetInt4(size_t row, Int4& v) const
{
    if ( !GetData().TryGetInt4(row, v) ) {
        return false;
    }
    v = v*GetMul()+GetAdd();
    return true;
}


bool CScaled_int_multi_data::TryGetInt8(size_t row, Int8& v) const
{
    if ( !GetData().TryGetInt8(row, v) ) {
        return false;
    }
    v = v*GetMul()+GetAdd();
    return true;
}


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE
