amber2lt.py
===========

*amber2lt.py* is a program for converting AMBER FRCMOD and DAT files
into moltemplate (LT) file format.

## *WARNING: ALPHA SOFTWARE. THIS SOFTWARE IS EXPERIMENTAL AS OF 2022-8-24*


## Usage:

```
amber2lt.py \
  --in AMBER_FILE \
  --name FORCE_FIELD_NAME \
  [--out MOLTEMPLATE_FILE.lt]
```


## Examples

### Example 1

Convert the GAFF force field from a file named "gaff.dat"
into moltemplate format ("gaff.lt")

```
amber2lt.py --in gaff.dat --name GAFF --out gaff.lt
```
Later on, you can create molecule definition files (eg "benzene.lt")
which refer to the force field you have just converted.  For example:
```
#---- "benzene.lt" file -----
import "gaff.lt"
Benzene inherits GAFF {
  write('Data Atoms') {
    $atom:c1  $mol  @atom:ca  -0.115   -0.739   1.189  -0.00733
    $atom:c2  $mol  @atom:ca  -0.115    0.614   1.208   0.35167
       :        :        :
  }
  write("Data Bond List") {
    $bond:b1 $atom:C1 $atom:C2
       :
  }
}
```


### Example 2:

Suppose when you run AmberTools, it creates a file named "benzene.mol2" and "benzene.frcmod".  You can use *amber2lt.py* and *mol22lt.py* to create all of the moltemplate files you need this way:

```
amber2lt.py --in benzene.frcmod --name MyForceField \
  >> my_force_field.lt

mol22lt.py --in benzene.mol2 \
           --out benzene.lt \
           --name Benzene \
           --ff MyForceField \
           --ff-file my_force_field.lt
```
In this case, the "benzene.lt" file generated by *mol22lt.py*
would resemble this file:
```
import "my_force_field.lt"
Benzene inherits MyForceField {
  write('Data Atoms') {
    $atom:c1  $mol  @atom:ca  -0.112739   -0.739   1.189  -0.00733
    $atom:c2  $mol  @atom:ca  -0.112739    0.614   1.208   0.35167
       :        :        :
  }
  write("Data Bond List") {
    $bond:b1 $atom:C1 $atom:C2
       :
  }
}

```
If you have multiple molecules, you can repeat this process for each of them.
(Each time, you do, your "my_force_field.lt" file will grow larger and larger
 as *amber2lt.py* appends more and more atom types and interaction types
 to the existing file.
 *If you need to make changes to the original FRCMOD file, remember to
 delete the "my_force_field.lt" file before you start over again.*)





## Arguments


### --in AMBER_FILE

Specify the name of the AMBER force-field file you want to convert
(eg. "gaff.dat" or "benzene.frcmod").
*If omitted, the terminal (stdin) is used by default.*


### --out MOLTEMPLATE_FILE.lt

Specify the name of the moltemplate file (LT file) you want to create.
(eg. "gaff.lt").
*If omitted, the terminal (stdout) is used by default.*


### --name FORCE_FIELD_NAME

The name of force field you want to create.
(This is not necessarily the same as the file name containing the force field.)
Suppose the name of the force field is "GAFF".  Later on, when you define
molecules that use this force field, you will refer to it this way
"MoleculeName inherits GAFF {..."

## Optional Arguments

AMBER .DAT and FRCMOD files are divided into multiple sections containing
mass, bond, angle, dihedral, improper, and nonbonded (pair) interactions.
Unfortunately, available documentation describing the file format
is somewhat ambiguous about where these sections begin and end.
The "amber2lt.py" attempts to guess where each section is,
however it sometimes fails.  When this happens, the conversion will fail.
You can get around this problem by manually dividing the original file
into seperate files containing only the lines of text that are relevant
for that section.  Then you can pass these files individually to
the *amber2lt.py* program using the following arguments:

### --mass mass.txt
### --bond bond.txt
### --angle angle.txt
### --dihedral dihedral.txt
### --improper improper.txt
### --pair pair.txt

Once you have specified the text in these files, the "amber2lt.py"
usually succeeds in the conversion.
Each file must not contain any blank lines or irrelevant text.

*Note that if you supply one of these arguments, you must supply all of them.*


## Python API

It is possible to access the functionality of *amber2lt.py* from 
within python.  Example:

```python
import moltemplate
# Open the file you want to convert
with open('gaff.dat', 'r') as file_in:
    lines_in = file_in.readlines()
# Now create a new moltemplate file
lines_out = ConvertAmber2Lt(object_name, lines_in)
# Write the contents of the new file
with open('gaff.lt', 'w') as file_out:
    file_out.write(''.join(output_lines))
# Alternatively, if you have loaded each section of the the AMBER file into
# different lists of lines (eg "lines_mass", "lines_bond", ...)
# then you can do the conversion this way:
# lines_out = ConvertAmberSections2Lt(object_name,
#                                     lines_mass,
#                                     lines_bond,
#                                     lines_angle,
#                                     lines_dihedral,
#                                     lines_improper,
#                                     lines_pair)
```
