
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301,USA
 */

#include "otr.h"
FORMAT_REC formats[] = {
	{ MODULE_NAME, "otr" },
	{ NULL, "Keys" },
	{ "kg_failed", "Key generation for %s: failed: %s (%s)" },
	{ "kg_completed", "Key generation for %s: completed in %d seconds. Reloading keys" },
	{ "kg_aborted_dup", "Key generation for %s: aborted. Key generation for %s still in progress" },
	{ "kg_aborted_dir", "Key generation for %s: aborted, failed creating directory %s: %s" },
	{ "kg_mkdir", "created directory %s" },
	{ "kg_pipe", "Key generation for %s: error creating pipe: %s" },
	{ "kg_fork", "Key generation for %s: fork() error: %s" },
	{ "kg_initiated", "Key generation for %s: initiated. This might take several minutes or on some systems even an hour. If you want to check that something is happening, see if there are two processes of your IRC client." },
	{ "kg_exited", "Key generation for %s: child terminated for unknown reason" },
	{ "kg_exitsig", "Key generation for %s: child was killed by signal %s" },
	{ "kg_pollerr", "Key generation for %s: error poll()ing child: %s" },
	{ "kg_abort", "Key generation for %s: aborted" },
	{ "kg_needacc", "I need an account name. Try something like /otr genkey mynick@irc.server.net" },
	{ "kg_noabort", "No ongoing key generation to abort" },
	{ "key_not_found", "no private keys found" },
	{ "key_loaded", "private keys loaded" },
	{ "key_load_error", "Error loading private keys: %s (%s)" },
	{ NULL, "Fingerprints" },
	{ "fp_saved", "fingerprints saved" },
	{ "fp_save_error", "Error saving fingerprints: %s (%s)" },
	{ "fp_not_found", "no fingerprints found" },
	{ "fp_loaded", "fingerprints loaded" },
	{ "fp_load_error", "Error loading fingerprints: %s (%s)" },
	{ "fp_trust", "Trusting fingerprint from %s" },
	{ NULL, "Instance Tags" },
	{ "instag_saved", "instance tags saved" },
	{ "instag_save_error", "Error saving instance tags: %s (%s)" },
	{ "instag_not_found", "no instance tags found" },
	{ "instag_loaded", "instance tags loaded" },
	{ "instag_load_error", "Error loading instance tags: %s (%s)" },
	{ NULL, "Callbacks" },
	{ "ops_notify_bug", "BUG() in ops_notify" },
	{ "ops_notify", "title: %s prim: %s sec: %s" },
	{ "ops_display_bug", "BUG() in ops_display" },
	{ "ops_display", "msg: %s" },
	{ "ops_sec", "gone secure" },
	{ "ops_fpcomp", "Your peer is not authenticated. To make sure you're talking to the right guy you can either agree on a secret and use the authentication described in /otr auth, or use the traditional way and compare fingerprints over a secure line (e.g. telephone) and subsequently enter /otr trust.  Your fingerprint is: %s. %s's fingerprint: %s" },
	{ "ops_insec", "gone insecure" },
	{ "ops_still_reply", "still secure (is reply)" },
	{ "ops_still_no_reply", "still secure (is not reply)" },
	{ "ops_log", "log msg: %s" },
	{ "ops_inject", "Couldn't inject message from %s for %s: %s" },
	{ "ops_handle_msg", "Message event %s, msg %s" },
	{ NULL, "SendingReceiving" },
	{ "send_failed", "send failed: msg=%s" },
	{ "send_change", "couldn't find context also OTR changed the outgoing message(BUG?)" },
	{ "send_fragment", "failed to fragment message: msg=%s" },
	{ "send_converted", "OTR converted sent message to %s" },
	{ "receive_ignore_query", "ignoring rest of OTR default query msg" },
	{ "receive_dequeued", "dequeued msg of length %d" },
	{ "receive_queued", "queued msg of length %d" },
	{ "receive_ignore", "ignoring protocol message of length %d, acc=%s, from=%s: %s" },
	{ "receive_converted", "OTR converted received message" },
	{ "otr_better_two", "<b>%s</b> has requested an <a href=\"http://otr.cypherpunks.ca/\">Off-the-Record private conversation</a>.  However, you do not have a plugin to support that." },
	{ "otr_better_three", "See <a href=\"http://otr.cypherpunks.ca/\">http://otr.cypherpunks.ca/</a> for more information." },
	{ NULL, "Context" },
	{ "ctx_not_found", "couldn't find context: acc=%s nick=%s" },
	{ "ctx_not_create", "couldn't create/find context: acc=%s from=%s" },
	{ NULL, "Authentication" },
	{ "auth_aborted_ongoing", "Ongoing authentication aborted" },
	{ "auth_aborted", "Authentication aborted" },
	{ "auth_responding", "Responding to authentication request..." },
	{ "auth_initiated", "Initiated authentication..." },
	{ "auth_have_old", "%s wanted to authenticate but an old authentication was still ongoing.  Old authentication will be aborted, please try again." },
	{ "auth_peer", "%s wants to authenticate. Type /otr auth <your-shared-secret> to complete." },
	{ "auth_peer_qa", "%s wants to authenticate and asked you \"%s\". Type /otr auth <answer> to complete." },
	{ "auth_peer_reply_wrong", "%s replied to an auth we didn't start." },
	{ "auth_peer_replied", "%s replied to our auth request..." },
	{ "auth_peer_wrong_smp3", "%s sent a wrong authentication message (SMP3)." },
	{ "auth_peer_wrong_smp4", "%s sent a wrong authentication message (SMP4)." },
	{ "auth_successful", "Authentication successful!" },
	{ "auth_failed", "Authentication failed!" },
	{ "auth_needenc", "You need to establish an OTR session before you can authenticate." },
	{ NULL, "Commands" },
	{ "cmd_otr", "We're alive" },
	{ "cmd_qnotfound", "Failed: Can't get nick and server of current query window. (Or maybe you're doing this in the status window?)" },
	{ "cmd_auth", "Please agree on a secret with your peer and then initiate the authentication with /otr auth <secret> or let him initiate. Should you initiate your peer will after a little while be instructed to enter the secret as well. Once he has done so the authentication will finish up. Should you have both typed in the same secret the authentication should be successful." },
	{ "cmd_debug_on", "Debug mode is on" },
	{ "cmd_debug_off", "Debug mode is off" },
	{ "cmd_finish", "Finished conversation with %s@%s." },
	{ "cmd_finishall_none", "No conversations to finish." },
	{ "cmd_version", "This is irc-otr version %s" },
	{ "peer_finished", "%s has finished the OTR conversation. If you want to continue talking enter /otr finish for plaintext or ?OTR? to restart OTR." },
	{ NULL, "Contexts" },
	{ "ctx_ctx_unencrypted", "%20s    %30s    plaintext" },
	{ "ctx_ctx_encrypted", "%20s    %30s    encrypted" },
	{ "ctx_ctx_finished", "%20s    %30s    finished" },
	{ "ctx_ctx_unknown", "%20s    %30s    unknown state(BUG?)" },
	{ "ctx_fps_no", "%s %rnot authenticated" },
	{ "ctx_fps_smp", "%s authenticated via shared secret (SMP)" },
	{ "ctx_fps_man", "%s authenticated manually" },
	{ "ctx_noctxs", "No active OTR contexts found" },
	{ NULL, "Statusbar" },
	{ "st_plaintext", "{sb plaintext}" },
	{ "st_untrusted", "{sb %rOTR(not auth'ed)}" },
	{ "st_trust_smp", "{sb OTR}" },
	{ "st_trust_manual", "{sb OTR}" },
	{ "st_smp_incoming", "{sb {hilight incoming auth request...}}" },
	{ "st_smp_outgoing", "{sb {hilight awaiting auth reply...}}" },
	{ "st_smp_finalize", "{sb {hilight finalizing auth...}}" },
	{ "st_smp_unknown", "{sb {hilight unknown auth state!}}" },
	{ "st_finished", "{sb finished}" },
	{ "st_unknown", "{sb {hilight state unknown (BUG!)}}" },
	{ NULL, NULL }
};

G_STATIC_ASSERT (G_N_ELEMENTS(formats) - 1 == TXT_ST_UNKNOWN + 1);
