#pragma once
/*
 *  $Id: layer-rectangle.h 28233 2025-07-16 10:46:57Z yeti-dn $
 *  Copyright (C) 2024 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWYUI_LAYER_RECTANGLE_H__
#define __GWYUI_LAYER_RECTANGLE_H__

#include <libgwyui/gwyvectorlayer.h>

G_BEGIN_DECLS

#define GWY_TYPE_LAYER_RECTANGLE            (gwy_layer_rectangle_get_type())
#define GWY_LAYER_RECTANGLE(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), GWY_TYPE_LAYER_RECTANGLE, GwyLayerRectangle))
#define GWY_LAYER_RECTANGLE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), GWY_TYPE_LAYER_RECTANGLE, GwyLayerRectangleClass))
#define GWY_IS_LAYER_RECTANGLE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), GWY_TYPE_LAYER_RECTANGLE))
#define GWY_IS_LAYER_RECTANGLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GWY_TYPE_LAYER_RECTANGLE))
#define GWY_LAYER_RECTANGLE_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), GWY_TYPE_LAYER_RECTANGLE, GwyLayerRectangleClass))

typedef struct _GwyLayerRectangle             GwyLayerRectangle;
typedef struct _GwyLayerRectangleClass        GwyLayerRectangleClass;
typedef struct _GwyLayerRectanglePrivate      GwyLayerRectanglePrivate;

struct _GwyLayerRectangle {
    GwyVectorLayer parent_instance;
    GwyLayerRectanglePrivate *priv;
};

struct _GwyLayerRectangleClass {
    GwyVectorLayerClass parent_class;
};

GType           gwy_layer_rectangle_get_type           (void)                      G_GNUC_CONST;
GwyVectorLayer* gwy_layer_rectangle_new                (void);
gboolean        gwy_layer_rectangle_get_draw_as_crop   (GwyLayerRectangle *layer);
void            gwy_layer_rectangle_set_draw_as_crop   (GwyLayerRectangle *layer,
                                                        gboolean draw_as_crop);
gboolean        gwy_layer_rectangle_get_draw_reflection(GwyLayerRectangle *layer);
void            gwy_layer_rectangle_set_draw_reflection(GwyLayerRectangle *layer,
                                                        gboolean draw_reflection);
gboolean        gwy_layer_rectangle_get_snap_to_center (GwyLayerRectangle *layer);
void            gwy_layer_rectangle_set_snap_to_center (GwyLayerRectangle *layer,
                                                        gboolean snap_to_center);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
