#pragma once
/*
 *  $Id: graph-key.h 28348 2025-08-11 16:29:06Z yeti-dn $
 *  Copyright (C) 2003-2024 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWYUI_GRAPH_KEY_H__
#define __GWYUI_GRAPH_KEY_H__

#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <libgwyui/gwygraphmodel.h>

G_BEGIN_DECLS

#define GWY_TYPE_GRAPH_KEY            (gwy_graph_key_get_type())
#define GWY_GRAPH_KEY(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), GWY_TYPE_GRAPH_KEY, GwyGraphKey))
#define GWY_GRAPH_KEY_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), GWY_TYPE_GRAPH_KEY, GwyGraphKeyClass))
#define GWY_IS_GRAPH_KEY(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), GWY_TYPE_GRAPH_KEY))
#define GWY_IS_GRAPH_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GWY_TYPE_GRAPH_KEY))
#define GWY_GRAPH_KEY_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), GWY_TYPE_GRAPH_KEY, GwyGraphKeyClass))

typedef struct _GwyGraphKey             GwyGraphKey;
typedef struct _GwyGraphKeyClass        GwyGraphKeyClass;
typedef struct _GwyGraphKeyPrivate      GwyGraphKeyPrivate;

struct _GwyGraphKey {
    GtkWidget widget;
    GwyGraphKeyPrivate *priv;
};

struct _GwyGraphKeyClass {
    GtkWidgetClass parent_class;

    void (*reserved1)(void);
    void (*reserved2)(void);
};

GType          gwy_graph_key_get_type         (void)                   G_GNUC_CONST;
GtkWidget*     gwy_graph_key_new              (void);
void           gwy_graph_key_set_model        (GwyGraphKey *label,
                                               GwyGraphModel *gmodel);
GwyGraphModel* gwy_graph_key_get_model        (GwyGraphKey *label);
void           gwy_graph_key_enable_user_input(GwyGraphKey *label,
                                               gboolean enable);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
