#pragma once
/*
 *  $Id: grain-quantities.h 28986 2025-12-12 17:15:25Z yeti-dn $
 *  Copyright (C) 2025 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWY_GRAIN_QUANTITIES_H__
#define __GWY_GRAIN_QUANTITIES_H__

#include <libgwyddion/nield.h>
#include <libgwyddion/field.h>
#include <libgwyddion/types.h>

G_BEGIN_DECLS

/* The values should not grow over 62 (to be usable as bit positions) */
typedef enum {
    GWY_GRAIN_PROJECTED_AREA          = 0,
    GWY_GRAIN_EQUIV_SQUARE_SIDE       = 1,
    GWY_GRAIN_EQUIV_DISC_RADIUS       = 2,
    GWY_GRAIN_SURFACE_AREA            = 3,
    GWY_GRAIN_MAXIMUM                 = 4,
    GWY_GRAIN_MINIMUM                 = 5,
    GWY_GRAIN_MEAN                    = 6,
    GWY_GRAIN_MEDIAN                  = 7,
    GWY_GRAIN_PIXEL_AREA              = 8,
    GWY_GRAIN_HALF_HEIGHT_AREA        = 9,
    GWY_GRAIN_FLAT_BOUNDARY_LENGTH    = 10,
    GWY_GRAIN_RMS                     = 11,
    GWY_GRAIN_MINIMUM_BOUND_SIZE      = 12,
    GWY_GRAIN_MINIMUM_BOUND_ANGLE     = 13,
    GWY_GRAIN_MAXIMUM_BOUND_SIZE      = 14,
    GWY_GRAIN_MAXIMUM_BOUND_ANGLE     = 15,
    GWY_GRAIN_CENTER_X                = 16,
    GWY_GRAIN_CENTER_Y                = 17,
    GWY_GRAIN_VOLUME_0                = 18,
    GWY_GRAIN_VOLUME_MIN              = 19,
    GWY_GRAIN_VOLUME_LAPLACE          = 20,
    /* Free space 21-22 */
    GWY_GRAIN_SLOPE_THETA             = 23,
    GWY_GRAIN_SLOPE_PHI               = 24,
    GWY_GRAIN_BOUNDARY_MAXIMUM        = 25,
    GWY_GRAIN_BOUNDARY_MINIMUM        = 26,
    GWY_GRAIN_CURVATURE_CENTER_X      = 27,
    GWY_GRAIN_CURVATURE_CENTER_Y      = 28,
    GWY_GRAIN_CURVATURE_CENTER_Z      = 29,
    GWY_GRAIN_CURVATURE1              = 30,
    GWY_GRAIN_CURVATURE2              = 31,
    GWY_GRAIN_CURVATURE_ANGLE1        = 32,
    GWY_GRAIN_CURVATURE_ANGLE2        = 33,
    GWY_GRAIN_INSCRIBED_DISC_R        = 34,
    GWY_GRAIN_INSCRIBED_DISC_X        = 35,
    GWY_GRAIN_INSCRIBED_DISC_Y        = 36,
    GWY_GRAIN_CONVEX_HULL_AREA        = 37,
    GWY_GRAIN_CIRCUMCIRCLE_R          = 38,
    GWY_GRAIN_CIRCUMCIRCLE_X          = 39,
    GWY_GRAIN_CIRCUMCIRCLE_Y          = 40,
    GWY_GRAIN_MEAN_RADIUS             = 41,
    GWY_GRAIN_EQUIV_ELLIPSE_MAJOR     = 42,
    GWY_GRAIN_EQUIV_ELLIPSE_MINOR     = 43,
    GWY_GRAIN_EQUIV_ELLIPSE_ANGLE     = 44,
    GWY_GRAIN_MINIMUM_MARTIN_DIAMETER = 45,
    GWY_GRAIN_MINIMUM_MARTIN_ANGLE    = 46,
    GWY_GRAIN_MAXIMUM_MARTIN_DIAMETER = 47,
    GWY_GRAIN_MAXIMUM_MARTIN_ANGLE    = 48,
} GwyGrainQuantity;

gboolean  gwy_grain_quantity_needs_same_units(GwyGrainQuantity quantity);
GwyUnit*  gwy_grain_quantity_get_units       (GwyGrainQuantity quantity,
                                              GwyUnit *siunitxy,
                                              GwyUnit *siunitz,
                                              GwyUnit *result);
gdouble*  gwy_nield_get_quantity             (GwyNield *nield,
                                              GwyField *field,
                                              GwyGrainQuantity quantity,
                                              gint *maxgno);
void      gwy_nield_get_quantities           (GwyNield *nield,
                                              GwyField *field,
                                              const GwyGrainQuantity *quantities,
                                              guint nquantities,
                                              gdouble **results);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
