//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package generated_blob

import (
	"encoding/json"
	"encoding/xml"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"reflect"
	"time"
)

// MarshalXML implements the xml.Marshaller interface for type AccessPolicy.
func (a AccessPolicy) MarshalXML(enc *xml.Encoder, start xml.StartElement) error {
	type alias AccessPolicy
	aux := &struct {
		*alias
		Expiry *timeRFC3339 `xml:"Expiry"`
		Start  *timeRFC3339 `xml:"Start"`
	}{
		alias:  (*alias)(&a),
		Expiry: (*timeRFC3339)(a.Expiry),
		Start:  (*timeRFC3339)(a.Start),
	}
	return enc.EncodeElement(aux, start)
}

// UnmarshalXML implements the xml.Unmarshaller interface for type AccessPolicy.
func (a *AccessPolicy) UnmarshalXML(dec *xml.Decoder, start xml.StartElement) error {
	type alias AccessPolicy
	aux := &struct {
		*alias
		Expiry *timeRFC3339 `xml:"Expiry"`
		Start  *timeRFC3339 `xml:"Start"`
	}{
		alias: (*alias)(a),
	}
	if err := dec.DecodeElement(aux, &start); err != nil {
		return err
	}
	a.Expiry = (*time.Time)(aux.Expiry)
	a.Start = (*time.Time)(aux.Start)
	return nil
}

// MarshalXML implements the xml.Marshaller interface for type ArrowConfiguration.
func (a ArrowConfiguration) MarshalXML(enc *xml.Encoder, start xml.StartElement) error {
	type alias ArrowConfiguration
	aux := &struct {
		*alias
		Schema *[]*ArrowField `xml:"Schema>Field"`
	}{
		alias: (*alias)(&a),
	}
	if a.Schema != nil {
		aux.Schema = &a.Schema
	}
	return enc.EncodeElement(aux, start)
}

// MarshalXML implements the xml.Marshaller interface for type BlobFlatListSegment.
func (b BlobFlatListSegment) MarshalXML(enc *xml.Encoder, start xml.StartElement) error {
	type alias BlobFlatListSegment
	aux := &struct {
		*alias
		PathItems *[]*PathItem `xml:"Blob"`
	}{
		alias: (*alias)(&b),
	}
	if b.PathItems != nil {
		aux.PathItems = &b.PathItems
	}
	return enc.EncodeElement(aux, start)
}

// MarshalXML implements the xml.Marshaller interface for type PathHierarchyListSegment.
func (b PathHierarchyListSegment) MarshalXML(enc *xml.Encoder, start xml.StartElement) error {
	type alias PathHierarchyListSegment
	aux := &struct {
		*alias
		PathItems    *[]*PathItem   `xml:"Blob"`
		PathPrefixes *[]*PathPrefix `xml:"PathPrefix"`
	}{
		alias: (*alias)(&b),
	}
	if b.PathItems != nil {
		aux.PathItems = &b.PathItems
	}
	if b.PathPrefixes != nil {
		aux.PathPrefixes = &b.PathPrefixes
	}
	return enc.EncodeElement(aux, start)
}

// MarshalXML implements the xml.Marshaller interface for type PathProperties.
func (b PathProperties) MarshalXML(enc *xml.Encoder, start xml.StartElement) error {
	type alias PathProperties
	aux := &struct {
		*alias
		AccessTierChangeTime        *timeRFC1123 `xml:"AccessTierChangeTime"`
		ContentMD5                  *string      `xml:"Content-MD5"`
		CopyCompletionTime          *timeRFC1123 `xml:"CopyCompletionTime"`
		CreationTime                *timeRFC1123 `xml:"Creation-Time"`
		DeletedTime                 *timeRFC1123 `xml:"DeletedTime"`
		ExpiresOn                   *timeRFC1123 `xml:"Expiry-Time"`
		ImmutabilityPolicyExpiresOn *timeRFC1123 `xml:"ImmutabilityPolicyUntilDate"`
		LastAccessedOn              *timeRFC1123 `xml:"LastAccessTime"`
		LastModified                *timeRFC1123 `xml:"Last-Modified"`
	}{
		alias:                       (*alias)(&b),
		AccessTierChangeTime:        (*timeRFC1123)(b.AccessTierChangeTime),
		CopyCompletionTime:          (*timeRFC1123)(b.CopyCompletionTime),
		CreationTime:                (*timeRFC1123)(b.CreationTime),
		DeletedTime:                 (*timeRFC1123)(b.DeletedTime),
		ExpiresOn:                   (*timeRFC1123)(b.ExpiresOn),
		ImmutabilityPolicyExpiresOn: (*timeRFC1123)(b.ImmutabilityPolicyExpiresOn),
		LastAccessedOn:              (*timeRFC1123)(b.LastAccessedOn),
		LastModified:                (*timeRFC1123)(b.LastModified),
	}
	if b.ContentMD5 != nil {
		encodedContentMD5 := runtime.EncodeByteArray(b.ContentMD5, runtime.Base64StdFormat)
		aux.ContentMD5 = &encodedContentMD5
	}
	return enc.EncodeElement(aux, start)
}

// UnmarshalXML implements the xml.Unmarshaller interface for type PathProperties.
func (b *PathProperties) UnmarshalXML(dec *xml.Decoder, start xml.StartElement) error {
	type alias PathProperties
	aux := &struct {
		*alias
		AccessTierChangeTime        *timeRFC1123 `xml:"AccessTierChangeTime"`
		ContentMD5                  *string      `xml:"Content-MD5"`
		CopyCompletionTime          *timeRFC1123 `xml:"CopyCompletionTime"`
		CreationTime                *timeRFC1123 `xml:"Creation-Time"`
		DeletedTime                 *timeRFC1123 `xml:"DeletedTime"`
		ExpiresOn                   *timeRFC1123 `xml:"Expiry-Time"`
		ImmutabilityPolicyExpiresOn *timeRFC1123 `xml:"ImmutabilityPolicyUntilDate"`
		LastAccessedOn              *timeRFC1123 `xml:"LastAccessTime"`
		LastModified                *timeRFC1123 `xml:"Last-Modified"`
	}{
		alias: (*alias)(b),
	}
	if err := dec.DecodeElement(aux, &start); err != nil {
		return err
	}
	b.AccessTierChangeTime = (*time.Time)(aux.AccessTierChangeTime)
	if aux.ContentMD5 != nil {
		if err := runtime.DecodeByteArray(*aux.ContentMD5, &b.ContentMD5, runtime.Base64StdFormat); err != nil {
			return err
		}
	}
	b.CopyCompletionTime = (*time.Time)(aux.CopyCompletionTime)
	b.CreationTime = (*time.Time)(aux.CreationTime)
	b.DeletedTime = (*time.Time)(aux.DeletedTime)
	b.ExpiresOn = (*time.Time)(aux.ExpiresOn)
	b.ImmutabilityPolicyExpiresOn = (*time.Time)(aux.ImmutabilityPolicyExpiresOn)
	b.LastAccessedOn = (*time.Time)(aux.LastAccessedOn)
	b.LastModified = (*time.Time)(aux.LastModified)
	return nil
}

// MarshalXML implements the xml.Marshaller interface for type BlobTags.
func (b BlobTags) MarshalXML(enc *xml.Encoder, start xml.StartElement) error {
	start.Name.Local = "Tags"
	type alias BlobTags
	aux := &struct {
		*alias
		BlobTagSet *[]*BlobTag `xml:"TagSet>Tag"`
	}{
		alias: (*alias)(&b),
	}
	if b.BlobTagSet != nil {
		aux.BlobTagSet = &b.BlobTagSet
	}
	return enc.EncodeElement(aux, start)
}

// MarshalXML implements the xml.Marshaller interface for type BlockList.
func (b BlockList) MarshalXML(enc *xml.Encoder, start xml.StartElement) error {
	type alias BlockList
	aux := &struct {
		*alias
		CommittedBlocks   *[]*Block `xml:"CommittedBlocks>Block"`
		UncommittedBlocks *[]*Block `xml:"UncommittedBlocks>Block"`
	}{
		alias: (*alias)(&b),
	}
	if b.CommittedBlocks != nil {
		aux.CommittedBlocks = &b.CommittedBlocks
	}
	if b.UncommittedBlocks != nil {
		aux.UncommittedBlocks = &b.UncommittedBlocks
	}
	return enc.EncodeElement(aux, start)
}

// MarshalXML implements the xml.Marshaller interface for type BlockLookupList.
func (b BlockLookupList) MarshalXML(enc *xml.Encoder, start xml.StartElement) error {
	start.Name.Local = "BlockList"
	type alias BlockLookupList
	aux := &struct {
		*alias
		Committed   *[]*string `xml:"Committed"`
		Latest      *[]*string `xml:"Latest"`
		Uncommitted *[]*string `xml:"Uncommitted"`
	}{
		alias: (*alias)(&b),
	}
	if b.Committed != nil {
		aux.Committed = &b.Committed
	}
	if b.Latest != nil {
		aux.Latest = &b.Latest
	}
	if b.Uncommitted != nil {
		aux.Uncommitted = &b.Uncommitted
	}
	return enc.EncodeElement(aux, start)
}

// UnmarshalXML implements the xml.Unmarshaller interface for type FileSystemItem.
func (c *FileSystemItem) UnmarshalXML(dec *xml.Decoder, start xml.StartElement) error {
	type alias FileSystemItem
	aux := &struct {
		*alias
		Metadata additionalProperties `xml:"Metadata"`
	}{
		alias: (*alias)(c),
	}
	if err := dec.DecodeElement(aux, &start); err != nil {
		return err
	}
	c.Metadata = (map[string]*string)(aux.Metadata)
	return nil
}

// MarshalXML implements the xml.Marshaller interface for type FileSystemProperties.
func (c FileSystemProperties) MarshalXML(enc *xml.Encoder, start xml.StartElement) error {
	type alias FileSystemProperties
	aux := &struct {
		*alias
		DeletedTime  *timeRFC1123 `xml:"DeletedTime"`
		LastModified *timeRFC1123 `xml:"Last-Modified"`
	}{
		alias:        (*alias)(&c),
		DeletedTime:  (*timeRFC1123)(c.DeletedTime),
		LastModified: (*timeRFC1123)(c.LastModified),
	}
	return enc.EncodeElement(aux, start)
}

// UnmarshalXML implements the xml.Unmarshaller interface for type FileSystemProperties.
func (c *FileSystemProperties) UnmarshalXML(dec *xml.Decoder, start xml.StartElement) error {
	type alias FileSystemProperties
	aux := &struct {
		*alias
		DeletedTime  *timeRFC1123 `xml:"DeletedTime"`
		LastModified *timeRFC1123 `xml:"Last-Modified"`
	}{
		alias: (*alias)(c),
	}
	if err := dec.DecodeElement(aux, &start); err != nil {
		return err
	}
	c.DeletedTime = (*time.Time)(aux.DeletedTime)
	c.LastModified = (*time.Time)(aux.LastModified)
	return nil
}

// MarshalXML implements the xml.Marshaller interface for type FilterBlobSegment.
func (f FilterBlobSegment) MarshalXML(enc *xml.Encoder, start xml.StartElement) error {
	type alias FilterBlobSegment
	aux := &struct {
		*alias
		Blobs *[]*FilterPathItem `xml:"Blobs>Blob"`
	}{
		alias: (*alias)(&f),
	}
	if f.Blobs != nil {
		aux.Blobs = &f.Blobs
	}
	return enc.EncodeElement(aux, start)
}

// MarshalXML implements the xml.Marshaller interface for type GeoReplication.
func (g GeoReplication) MarshalXML(enc *xml.Encoder, start xml.StartElement) error {
	type alias GeoReplication
	aux := &struct {
		*alias
		LastSyncTime *timeRFC1123 `xml:"LastSyncTime"`
	}{
		alias:        (*alias)(&g),
		LastSyncTime: (*timeRFC1123)(g.LastSyncTime),
	}
	return enc.EncodeElement(aux, start)
}

// UnmarshalXML implements the xml.Unmarshaller interface for type GeoReplication.
func (g *GeoReplication) UnmarshalXML(dec *xml.Decoder, start xml.StartElement) error {
	type alias GeoReplication
	aux := &struct {
		*alias
		LastSyncTime *timeRFC1123 `xml:"LastSyncTime"`
	}{
		alias: (*alias)(g),
	}
	if err := dec.DecodeElement(aux, &start); err != nil {
		return err
	}
	g.LastSyncTime = (*time.Time)(aux.LastSyncTime)
	return nil
}

// MarshalXML implements the xml.Marshaller interface for type ListFileSystemsSegmentResponse.
func (l ListFileSystemsSegmentResponse) MarshalXML(enc *xml.Encoder, start xml.StartElement) error {
	type alias ListFileSystemsSegmentResponse
	aux := &struct {
		*alias
		FileSystemItems *[]*FileSystemItem `xml:"Containers>Container"`
	}{
		alias: (*alias)(&l),
	}
	if l.FileSystemItems != nil {
		aux.FileSystemItems = &l.FileSystemItems
	}
	return enc.EncodeElement(aux, start)
}

// MarshalXML implements the xml.Marshaller interface for type PageList.
func (p PageList) MarshalXML(enc *xml.Encoder, start xml.StartElement) error {
	type alias PageList
	aux := &struct {
		*alias
		ClearRange *[]*ClearRange `xml:"ClearRange"`
		PageRange  *[]*PageRange  `xml:"PageRange"`
	}{
		alias: (*alias)(&p),
	}
	if p.ClearRange != nil {
		aux.ClearRange = &p.ClearRange
	}
	if p.PageRange != nil {
		aux.PageRange = &p.PageRange
	}
	return enc.EncodeElement(aux, start)
}

// MarshalXML implements the xml.Marshaller interface for type QueryRequest.
func (q QueryRequest) MarshalXML(enc *xml.Encoder, start xml.StartElement) error {
	start.Name.Local = "QueryRequest"
	type alias QueryRequest
	aux := &struct {
		*alias
	}{
		alias: (*alias)(&q),
	}
	return enc.EncodeElement(aux, start)
}

// MarshalJSON implements the json.Marshaller interface for type StorageError.
func (s StorageError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "Message", s.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageError.
func (s *StorageError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "Message":
			err = unpopulate(val, "Message", &s.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalXML implements the xml.Marshaller interface for type StorageServiceProperties.
func (s StorageServiceProperties) MarshalXML(enc *xml.Encoder, start xml.StartElement) error {
	type alias StorageServiceProperties
	aux := &struct {
		*alias
		CORS *[]*CORSRule `xml:"Cors>CorsRule"`
	}{
		alias: (*alias)(&s),
	}
	if s.CORS != nil {
		aux.CORS = &s.CORS
	}
	return enc.EncodeElement(aux, start)
}

// MarshalXML implements the xml.Marshaller interface for type UserDelegationKey.
func (u UserDelegationKey) MarshalXML(enc *xml.Encoder, start xml.StartElement) error {
	type alias UserDelegationKey
	aux := &struct {
		*alias
		SignedExpiry *timeRFC3339 `xml:"SignedExpiry"`
		SignedStart  *timeRFC3339 `xml:"SignedStart"`
	}{
		alias:        (*alias)(&u),
		SignedExpiry: (*timeRFC3339)(u.SignedExpiry),
		SignedStart:  (*timeRFC3339)(u.SignedStart),
	}
	return enc.EncodeElement(aux, start)
}

// UnmarshalXML implements the xml.Unmarshaller interface for type UserDelegationKey.
func (u *UserDelegationKey) UnmarshalXML(dec *xml.Decoder, start xml.StartElement) error {
	type alias UserDelegationKey
	aux := &struct {
		*alias
		SignedExpiry *timeRFC3339 `xml:"SignedExpiry"`
		SignedStart  *timeRFC3339 `xml:"SignedStart"`
	}{
		alias: (*alias)(u),
	}
	if err := dec.DecodeElement(aux, &start); err != nil {
		return err
	}
	u.SignedExpiry = (*time.Time)(aux.SignedExpiry)
	u.SignedStart = (*time.Time)(aux.SignedStart)
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
