//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storsimple1200series/armstorsimple1200series"
	"net/http"
	"net/url"
	"regexp"
)

// ManagersServer is a fake server for instances of the armstorsimple1200series.ManagersClient type.
type ManagersServer struct {
	// CreateExtendedInfo is the fake for method ManagersClient.CreateExtendedInfo
	// HTTP status codes to indicate success: http.StatusOK
	CreateExtendedInfo func(ctx context.Context, resourceGroupName string, managerName string, managerExtendedInfo armstorsimple1200series.ManagerExtendedInfo, options *armstorsimple1200series.ManagersClientCreateExtendedInfoOptions) (resp azfake.Responder[armstorsimple1200series.ManagersClientCreateExtendedInfoResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdate is the fake for method ManagersClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, managerName string, manager armstorsimple1200series.Manager, options *armstorsimple1200series.ManagersClientCreateOrUpdateOptions) (resp azfake.Responder[armstorsimple1200series.ManagersClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method ManagersClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, managerName string, options *armstorsimple1200series.ManagersClientDeleteOptions) (resp azfake.Responder[armstorsimple1200series.ManagersClientDeleteResponse], errResp azfake.ErrorResponder)

	// DeleteExtendedInfo is the fake for method ManagersClient.DeleteExtendedInfo
	// HTTP status codes to indicate success: http.StatusNoContent
	DeleteExtendedInfo func(ctx context.Context, resourceGroupName string, managerName string, options *armstorsimple1200series.ManagersClientDeleteExtendedInfoOptions) (resp azfake.Responder[armstorsimple1200series.ManagersClientDeleteExtendedInfoResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ManagersClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, managerName string, options *armstorsimple1200series.ManagersClientGetOptions) (resp azfake.Responder[armstorsimple1200series.ManagersClientGetResponse], errResp azfake.ErrorResponder)

	// GetEncryptionKey is the fake for method ManagersClient.GetEncryptionKey
	// HTTP status codes to indicate success: http.StatusOK
	GetEncryptionKey func(ctx context.Context, resourceGroupName string, managerName string, options *armstorsimple1200series.ManagersClientGetEncryptionKeyOptions) (resp azfake.Responder[armstorsimple1200series.ManagersClientGetEncryptionKeyResponse], errResp azfake.ErrorResponder)

	// GetEncryptionSettings is the fake for method ManagersClient.GetEncryptionSettings
	// HTTP status codes to indicate success: http.StatusOK
	GetEncryptionSettings func(ctx context.Context, resourceGroupName string, managerName string, options *armstorsimple1200series.ManagersClientGetEncryptionSettingsOptions) (resp azfake.Responder[armstorsimple1200series.ManagersClientGetEncryptionSettingsResponse], errResp azfake.ErrorResponder)

	// GetExtendedInfo is the fake for method ManagersClient.GetExtendedInfo
	// HTTP status codes to indicate success: http.StatusOK
	GetExtendedInfo func(ctx context.Context, resourceGroupName string, managerName string, options *armstorsimple1200series.ManagersClientGetExtendedInfoOptions) (resp azfake.Responder[armstorsimple1200series.ManagersClientGetExtendedInfoResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method ManagersClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armstorsimple1200series.ManagersClientListOptions) (resp azfake.PagerResponder[armstorsimple1200series.ManagersClientListResponse])

	// NewListByResourceGroupPager is the fake for method ManagersClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armstorsimple1200series.ManagersClientListByResourceGroupOptions) (resp azfake.PagerResponder[armstorsimple1200series.ManagersClientListByResourceGroupResponse])

	// NewListMetricDefinitionPager is the fake for method ManagersClient.NewListMetricDefinitionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListMetricDefinitionPager func(resourceGroupName string, managerName string, options *armstorsimple1200series.ManagersClientListMetricDefinitionOptions) (resp azfake.PagerResponder[armstorsimple1200series.ManagersClientListMetricDefinitionResponse])

	// NewListMetricsPager is the fake for method ManagersClient.NewListMetricsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListMetricsPager func(resourceGroupName string, managerName string, options *armstorsimple1200series.ManagersClientListMetricsOptions) (resp azfake.PagerResponder[armstorsimple1200series.ManagersClientListMetricsResponse])

	// Update is the fake for method ManagersClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, managerName string, parameters armstorsimple1200series.ManagerPatch, options *armstorsimple1200series.ManagersClientUpdateOptions) (resp azfake.Responder[armstorsimple1200series.ManagersClientUpdateResponse], errResp azfake.ErrorResponder)

	// UpdateExtendedInfo is the fake for method ManagersClient.UpdateExtendedInfo
	// HTTP status codes to indicate success: http.StatusOK
	UpdateExtendedInfo func(ctx context.Context, resourceGroupName string, managerName string, ifMatch string, managerExtendedInfo armstorsimple1200series.ManagerExtendedInfo, options *armstorsimple1200series.ManagersClientUpdateExtendedInfoOptions) (resp azfake.Responder[armstorsimple1200series.ManagersClientUpdateExtendedInfoResponse], errResp azfake.ErrorResponder)

	// UploadRegistrationCertificate is the fake for method ManagersClient.UploadRegistrationCertificate
	// HTTP status codes to indicate success: http.StatusOK
	UploadRegistrationCertificate func(ctx context.Context, certificateName string, resourceGroupName string, managerName string, uploadCertificateRequestrequest armstorsimple1200series.UploadCertificateRequest, options *armstorsimple1200series.ManagersClientUploadRegistrationCertificateOptions) (resp azfake.Responder[armstorsimple1200series.ManagersClientUploadRegistrationCertificateResponse], errResp azfake.ErrorResponder)
}

// NewManagersServerTransport creates a new instance of ManagersServerTransport with the provided implementation.
// The returned ManagersServerTransport instance is connected to an instance of armstorsimple1200series.ManagersClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewManagersServerTransport(srv *ManagersServer) *ManagersServerTransport {
	return &ManagersServerTransport{
		srv:                          srv,
		newListPager:                 newTracker[azfake.PagerResponder[armstorsimple1200series.ManagersClientListResponse]](),
		newListByResourceGroupPager:  newTracker[azfake.PagerResponder[armstorsimple1200series.ManagersClientListByResourceGroupResponse]](),
		newListMetricDefinitionPager: newTracker[azfake.PagerResponder[armstorsimple1200series.ManagersClientListMetricDefinitionResponse]](),
		newListMetricsPager:          newTracker[azfake.PagerResponder[armstorsimple1200series.ManagersClientListMetricsResponse]](),
	}
}

// ManagersServerTransport connects instances of armstorsimple1200series.ManagersClient to instances of ManagersServer.
// Don't use this type directly, use NewManagersServerTransport instead.
type ManagersServerTransport struct {
	srv                          *ManagersServer
	newListPager                 *tracker[azfake.PagerResponder[armstorsimple1200series.ManagersClientListResponse]]
	newListByResourceGroupPager  *tracker[azfake.PagerResponder[armstorsimple1200series.ManagersClientListByResourceGroupResponse]]
	newListMetricDefinitionPager *tracker[azfake.PagerResponder[armstorsimple1200series.ManagersClientListMetricDefinitionResponse]]
	newListMetricsPager          *tracker[azfake.PagerResponder[armstorsimple1200series.ManagersClientListMetricsResponse]]
}

// Do implements the policy.Transporter interface for ManagersServerTransport.
func (m *ManagersServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ManagersClient.CreateExtendedInfo":
		resp, err = m.dispatchCreateExtendedInfo(req)
	case "ManagersClient.CreateOrUpdate":
		resp, err = m.dispatchCreateOrUpdate(req)
	case "ManagersClient.Delete":
		resp, err = m.dispatchDelete(req)
	case "ManagersClient.DeleteExtendedInfo":
		resp, err = m.dispatchDeleteExtendedInfo(req)
	case "ManagersClient.Get":
		resp, err = m.dispatchGet(req)
	case "ManagersClient.GetEncryptionKey":
		resp, err = m.dispatchGetEncryptionKey(req)
	case "ManagersClient.GetEncryptionSettings":
		resp, err = m.dispatchGetEncryptionSettings(req)
	case "ManagersClient.GetExtendedInfo":
		resp, err = m.dispatchGetExtendedInfo(req)
	case "ManagersClient.NewListPager":
		resp, err = m.dispatchNewListPager(req)
	case "ManagersClient.NewListByResourceGroupPager":
		resp, err = m.dispatchNewListByResourceGroupPager(req)
	case "ManagersClient.NewListMetricDefinitionPager":
		resp, err = m.dispatchNewListMetricDefinitionPager(req)
	case "ManagersClient.NewListMetricsPager":
		resp, err = m.dispatchNewListMetricsPager(req)
	case "ManagersClient.Update":
		resp, err = m.dispatchUpdate(req)
	case "ManagersClient.UpdateExtendedInfo":
		resp, err = m.dispatchUpdateExtendedInfo(req)
	case "ManagersClient.UploadRegistrationCertificate":
		resp, err = m.dispatchUploadRegistrationCertificate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *ManagersServerTransport) dispatchCreateExtendedInfo(req *http.Request) (*http.Response, error) {
	if m.srv.CreateExtendedInfo == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateExtendedInfo not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/extendedInformation/vaultExtendedInfo`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armstorsimple1200series.ManagerExtendedInfo](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.CreateExtendedInfo(req.Context(), resourceGroupNameParam, managerNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ManagerExtendedInfo, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagersServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if m.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armstorsimple1200series.Manager](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, managerNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Manager, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagersServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if m.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.Delete(req.Context(), resourceGroupNameParam, managerNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagersServerTransport) dispatchDeleteExtendedInfo(req *http.Request) (*http.Response, error) {
	if m.srv.DeleteExtendedInfo == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteExtendedInfo not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/extendedInformation/vaultExtendedInfo`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.DeleteExtendedInfo(req.Context(), resourceGroupNameParam, managerNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagersServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if m.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.Get(req.Context(), resourceGroupNameParam, managerNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Manager, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagersServerTransport) dispatchGetEncryptionKey(req *http.Request) (*http.Response, error) {
	if m.srv.GetEncryptionKey == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetEncryptionKey not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getEncryptionKey`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.GetEncryptionKey(req.Context(), resourceGroupNameParam, managerNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SymmetricEncryptedSecret, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagersServerTransport) dispatchGetEncryptionSettings(req *http.Request) (*http.Response, error) {
	if m.srv.GetEncryptionSettings == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetEncryptionSettings not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/encryptionSettings/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.GetEncryptionSettings(req.Context(), resourceGroupNameParam, managerNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).EncryptionSettings, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagersServerTransport) dispatchGetExtendedInfo(req *http.Request) (*http.Response, error) {
	if m.srv.GetExtendedInfo == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetExtendedInfo not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/extendedInformation/vaultExtendedInfo`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.GetExtendedInfo(req.Context(), resourceGroupNameParam, managerNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ManagerExtendedInfo, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagersServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := m.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := m.srv.NewListPager(nil)
		newListPager = &resp
		m.newListPager.add(req, newListPager)
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		m.newListPager.remove(req)
	}
	return resp, nil
}

func (m *ManagersServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := m.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListByResourceGroupPager(resourceGroupNameParam, nil)
		newListByResourceGroupPager = &resp
		m.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		m.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (m *ManagersServerTransport) dispatchNewListMetricDefinitionPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListMetricDefinitionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListMetricDefinitionPager not implemented")}
	}
	newListMetricDefinitionPager := m.newListMetricDefinitionPager.get(req)
	if newListMetricDefinitionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/metricsDefinitions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListMetricDefinitionPager(resourceGroupNameParam, managerNameParam, nil)
		newListMetricDefinitionPager = &resp
		m.newListMetricDefinitionPager.add(req, newListMetricDefinitionPager)
	}
	resp, err := server.PagerResponderNext(newListMetricDefinitionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListMetricDefinitionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListMetricDefinitionPager) {
		m.newListMetricDefinitionPager.remove(req)
	}
	return resp, nil
}

func (m *ManagersServerTransport) dispatchNewListMetricsPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListMetricsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListMetricsPager not implemented")}
	}
	newListMetricsPager := m.newListMetricsPager.get(req)
	if newListMetricsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/metrics`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armstorsimple1200series.ManagersClientListMetricsOptions
		if filterParam != nil {
			options = &armstorsimple1200series.ManagersClientListMetricsOptions{
				Filter: filterParam,
			}
		}
		resp := m.srv.NewListMetricsPager(resourceGroupNameParam, managerNameParam, options)
		newListMetricsPager = &resp
		m.newListMetricsPager.add(req, newListMetricsPager)
	}
	resp, err := server.PagerResponderNext(newListMetricsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListMetricsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListMetricsPager) {
		m.newListMetricsPager.remove(req)
	}
	return resp, nil
}

func (m *ManagersServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if m.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armstorsimple1200series.ManagerPatch](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.Update(req.Context(), resourceGroupNameParam, managerNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Manager, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagersServerTransport) dispatchUpdateExtendedInfo(req *http.Request) (*http.Response, error) {
	if m.srv.UpdateExtendedInfo == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateExtendedInfo not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/extendedInformation/vaultExtendedInfo`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armstorsimple1200series.ManagerExtendedInfo](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.UpdateExtendedInfo(req.Context(), resourceGroupNameParam, managerNameParam, getHeaderValue(req.Header, "If-Match"), body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ManagerExtendedInfo, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagersServerTransport) dispatchUploadRegistrationCertificate(req *http.Request) (*http.Response, error) {
	if m.srv.UploadRegistrationCertificate == nil {
		return nil, &nonRetriableError{errors.New("fake for method UploadRegistrationCertificate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/certificates/(?P<certificateName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armstorsimple1200series.UploadCertificateRequest](req)
	if err != nil {
		return nil, err
	}
	certificateNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("certificateName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.UploadRegistrationCertificate(req.Context(), certificateNameParam, resourceGroupNameParam, managerNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).UploadCertificateResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
