//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/managednetworkfabric/armmanagednetworkfabric"
	"net/http"
	"net/url"
	"regexp"
)

// L3IsolationDomainsServer is a fake server for instances of the armmanagednetworkfabric.L3IsolationDomainsClient type.
type L3IsolationDomainsServer struct {
	// BeginCommitConfiguration is the fake for method L3IsolationDomainsClient.BeginCommitConfiguration
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCommitConfiguration func(ctx context.Context, resourceGroupName string, l3IsolationDomainName string, options *armmanagednetworkfabric.L3IsolationDomainsClientBeginCommitConfigurationOptions) (resp azfake.PollerResponder[armmanagednetworkfabric.L3IsolationDomainsClientCommitConfigurationResponse], errResp azfake.ErrorResponder)

	// BeginCreate is the fake for method L3IsolationDomainsClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreate func(ctx context.Context, resourceGroupName string, l3IsolationDomainName string, body armmanagednetworkfabric.L3IsolationDomain, options *armmanagednetworkfabric.L3IsolationDomainsClientBeginCreateOptions) (resp azfake.PollerResponder[armmanagednetworkfabric.L3IsolationDomainsClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method L3IsolationDomainsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, l3IsolationDomainName string, options *armmanagednetworkfabric.L3IsolationDomainsClientBeginDeleteOptions) (resp azfake.PollerResponder[armmanagednetworkfabric.L3IsolationDomainsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method L3IsolationDomainsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, l3IsolationDomainName string, options *armmanagednetworkfabric.L3IsolationDomainsClientGetOptions) (resp azfake.Responder[armmanagednetworkfabric.L3IsolationDomainsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByResourceGroupPager is the fake for method L3IsolationDomainsClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armmanagednetworkfabric.L3IsolationDomainsClientListByResourceGroupOptions) (resp azfake.PagerResponder[armmanagednetworkfabric.L3IsolationDomainsClientListByResourceGroupResponse])

	// NewListBySubscriptionPager is the fake for method L3IsolationDomainsClient.NewListBySubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySubscriptionPager func(options *armmanagednetworkfabric.L3IsolationDomainsClientListBySubscriptionOptions) (resp azfake.PagerResponder[armmanagednetworkfabric.L3IsolationDomainsClientListBySubscriptionResponse])

	// BeginUpdate is the fake for method L3IsolationDomainsClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, l3IsolationDomainName string, body armmanagednetworkfabric.L3IsolationDomainPatch, options *armmanagednetworkfabric.L3IsolationDomainsClientBeginUpdateOptions) (resp azfake.PollerResponder[armmanagednetworkfabric.L3IsolationDomainsClientUpdateResponse], errResp azfake.ErrorResponder)

	// BeginUpdateAdministrativeState is the fake for method L3IsolationDomainsClient.BeginUpdateAdministrativeState
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdateAdministrativeState func(ctx context.Context, resourceGroupName string, l3IsolationDomainName string, body armmanagednetworkfabric.UpdateAdministrativeState, options *armmanagednetworkfabric.L3IsolationDomainsClientBeginUpdateAdministrativeStateOptions) (resp azfake.PollerResponder[armmanagednetworkfabric.L3IsolationDomainsClientUpdateAdministrativeStateResponse], errResp azfake.ErrorResponder)

	// BeginValidateConfiguration is the fake for method L3IsolationDomainsClient.BeginValidateConfiguration
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginValidateConfiguration func(ctx context.Context, resourceGroupName string, l3IsolationDomainName string, options *armmanagednetworkfabric.L3IsolationDomainsClientBeginValidateConfigurationOptions) (resp azfake.PollerResponder[armmanagednetworkfabric.L3IsolationDomainsClientValidateConfigurationResponse], errResp azfake.ErrorResponder)
}

// NewL3IsolationDomainsServerTransport creates a new instance of L3IsolationDomainsServerTransport with the provided implementation.
// The returned L3IsolationDomainsServerTransport instance is connected to an instance of armmanagednetworkfabric.L3IsolationDomainsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewL3IsolationDomainsServerTransport(srv *L3IsolationDomainsServer) *L3IsolationDomainsServerTransport {
	return &L3IsolationDomainsServerTransport{
		srv:                            srv,
		beginCommitConfiguration:       newTracker[azfake.PollerResponder[armmanagednetworkfabric.L3IsolationDomainsClientCommitConfigurationResponse]](),
		beginCreate:                    newTracker[azfake.PollerResponder[armmanagednetworkfabric.L3IsolationDomainsClientCreateResponse]](),
		beginDelete:                    newTracker[azfake.PollerResponder[armmanagednetworkfabric.L3IsolationDomainsClientDeleteResponse]](),
		newListByResourceGroupPager:    newTracker[azfake.PagerResponder[armmanagednetworkfabric.L3IsolationDomainsClientListByResourceGroupResponse]](),
		newListBySubscriptionPager:     newTracker[azfake.PagerResponder[armmanagednetworkfabric.L3IsolationDomainsClientListBySubscriptionResponse]](),
		beginUpdate:                    newTracker[azfake.PollerResponder[armmanagednetworkfabric.L3IsolationDomainsClientUpdateResponse]](),
		beginUpdateAdministrativeState: newTracker[azfake.PollerResponder[armmanagednetworkfabric.L3IsolationDomainsClientUpdateAdministrativeStateResponse]](),
		beginValidateConfiguration:     newTracker[azfake.PollerResponder[armmanagednetworkfabric.L3IsolationDomainsClientValidateConfigurationResponse]](),
	}
}

// L3IsolationDomainsServerTransport connects instances of armmanagednetworkfabric.L3IsolationDomainsClient to instances of L3IsolationDomainsServer.
// Don't use this type directly, use NewL3IsolationDomainsServerTransport instead.
type L3IsolationDomainsServerTransport struct {
	srv                            *L3IsolationDomainsServer
	beginCommitConfiguration       *tracker[azfake.PollerResponder[armmanagednetworkfabric.L3IsolationDomainsClientCommitConfigurationResponse]]
	beginCreate                    *tracker[azfake.PollerResponder[armmanagednetworkfabric.L3IsolationDomainsClientCreateResponse]]
	beginDelete                    *tracker[azfake.PollerResponder[armmanagednetworkfabric.L3IsolationDomainsClientDeleteResponse]]
	newListByResourceGroupPager    *tracker[azfake.PagerResponder[armmanagednetworkfabric.L3IsolationDomainsClientListByResourceGroupResponse]]
	newListBySubscriptionPager     *tracker[azfake.PagerResponder[armmanagednetworkfabric.L3IsolationDomainsClientListBySubscriptionResponse]]
	beginUpdate                    *tracker[azfake.PollerResponder[armmanagednetworkfabric.L3IsolationDomainsClientUpdateResponse]]
	beginUpdateAdministrativeState *tracker[azfake.PollerResponder[armmanagednetworkfabric.L3IsolationDomainsClientUpdateAdministrativeStateResponse]]
	beginValidateConfiguration     *tracker[azfake.PollerResponder[armmanagednetworkfabric.L3IsolationDomainsClientValidateConfigurationResponse]]
}

// Do implements the policy.Transporter interface for L3IsolationDomainsServerTransport.
func (l *L3IsolationDomainsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "L3IsolationDomainsClient.BeginCommitConfiguration":
		resp, err = l.dispatchBeginCommitConfiguration(req)
	case "L3IsolationDomainsClient.BeginCreate":
		resp, err = l.dispatchBeginCreate(req)
	case "L3IsolationDomainsClient.BeginDelete":
		resp, err = l.dispatchBeginDelete(req)
	case "L3IsolationDomainsClient.Get":
		resp, err = l.dispatchGet(req)
	case "L3IsolationDomainsClient.NewListByResourceGroupPager":
		resp, err = l.dispatchNewListByResourceGroupPager(req)
	case "L3IsolationDomainsClient.NewListBySubscriptionPager":
		resp, err = l.dispatchNewListBySubscriptionPager(req)
	case "L3IsolationDomainsClient.BeginUpdate":
		resp, err = l.dispatchBeginUpdate(req)
	case "L3IsolationDomainsClient.BeginUpdateAdministrativeState":
		resp, err = l.dispatchBeginUpdateAdministrativeState(req)
	case "L3IsolationDomainsClient.BeginValidateConfiguration":
		resp, err = l.dispatchBeginValidateConfiguration(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (l *L3IsolationDomainsServerTransport) dispatchBeginCommitConfiguration(req *http.Request) (*http.Response, error) {
	if l.srv.BeginCommitConfiguration == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCommitConfiguration not implemented")}
	}
	beginCommitConfiguration := l.beginCommitConfiguration.get(req)
	if beginCommitConfiguration == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/l3IsolationDomains/(?P<l3IsolationDomainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/commitConfiguration`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		l3IsolationDomainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("l3IsolationDomainName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := l.srv.BeginCommitConfiguration(req.Context(), resourceGroupNameParam, l3IsolationDomainNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCommitConfiguration = &respr
		l.beginCommitConfiguration.add(req, beginCommitConfiguration)
	}

	resp, err := server.PollerResponderNext(beginCommitConfiguration, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		l.beginCommitConfiguration.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCommitConfiguration) {
		l.beginCommitConfiguration.remove(req)
	}

	return resp, nil
}

func (l *L3IsolationDomainsServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if l.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := l.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/l3IsolationDomains/(?P<l3IsolationDomainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmanagednetworkfabric.L3IsolationDomain](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		l3IsolationDomainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("l3IsolationDomainName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := l.srv.BeginCreate(req.Context(), resourceGroupNameParam, l3IsolationDomainNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		l.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		l.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		l.beginCreate.remove(req)
	}

	return resp, nil
}

func (l *L3IsolationDomainsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if l.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := l.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/l3IsolationDomains/(?P<l3IsolationDomainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		l3IsolationDomainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("l3IsolationDomainName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := l.srv.BeginDelete(req.Context(), resourceGroupNameParam, l3IsolationDomainNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		l.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		l.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		l.beginDelete.remove(req)
	}

	return resp, nil
}

func (l *L3IsolationDomainsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if l.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/l3IsolationDomains/(?P<l3IsolationDomainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	l3IsolationDomainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("l3IsolationDomainName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := l.srv.Get(req.Context(), resourceGroupNameParam, l3IsolationDomainNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).L3IsolationDomain, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *L3IsolationDomainsServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if l.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := l.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/l3IsolationDomains`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := l.srv.NewListByResourceGroupPager(resourceGroupNameParam, nil)
		newListByResourceGroupPager = &resp
		l.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armmanagednetworkfabric.L3IsolationDomainsClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		l.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		l.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (l *L3IsolationDomainsServerTransport) dispatchNewListBySubscriptionPager(req *http.Request) (*http.Response, error) {
	if l.srv.NewListBySubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySubscriptionPager not implemented")}
	}
	newListBySubscriptionPager := l.newListBySubscriptionPager.get(req)
	if newListBySubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/l3IsolationDomains`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := l.srv.NewListBySubscriptionPager(nil)
		newListBySubscriptionPager = &resp
		l.newListBySubscriptionPager.add(req, newListBySubscriptionPager)
		server.PagerResponderInjectNextLinks(newListBySubscriptionPager, req, func(page *armmanagednetworkfabric.L3IsolationDomainsClientListBySubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		l.newListBySubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySubscriptionPager) {
		l.newListBySubscriptionPager.remove(req)
	}
	return resp, nil
}

func (l *L3IsolationDomainsServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if l.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := l.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/l3IsolationDomains/(?P<l3IsolationDomainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmanagednetworkfabric.L3IsolationDomainPatch](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		l3IsolationDomainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("l3IsolationDomainName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := l.srv.BeginUpdate(req.Context(), resourceGroupNameParam, l3IsolationDomainNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		l.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		l.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		l.beginUpdate.remove(req)
	}

	return resp, nil
}

func (l *L3IsolationDomainsServerTransport) dispatchBeginUpdateAdministrativeState(req *http.Request) (*http.Response, error) {
	if l.srv.BeginUpdateAdministrativeState == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdateAdministrativeState not implemented")}
	}
	beginUpdateAdministrativeState := l.beginUpdateAdministrativeState.get(req)
	if beginUpdateAdministrativeState == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/l3IsolationDomains/(?P<l3IsolationDomainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/updateAdministrativeState`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmanagednetworkfabric.UpdateAdministrativeState](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		l3IsolationDomainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("l3IsolationDomainName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := l.srv.BeginUpdateAdministrativeState(req.Context(), resourceGroupNameParam, l3IsolationDomainNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdateAdministrativeState = &respr
		l.beginUpdateAdministrativeState.add(req, beginUpdateAdministrativeState)
	}

	resp, err := server.PollerResponderNext(beginUpdateAdministrativeState, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		l.beginUpdateAdministrativeState.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdateAdministrativeState) {
		l.beginUpdateAdministrativeState.remove(req)
	}

	return resp, nil
}

func (l *L3IsolationDomainsServerTransport) dispatchBeginValidateConfiguration(req *http.Request) (*http.Response, error) {
	if l.srv.BeginValidateConfiguration == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginValidateConfiguration not implemented")}
	}
	beginValidateConfiguration := l.beginValidateConfiguration.get(req)
	if beginValidateConfiguration == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/l3IsolationDomains/(?P<l3IsolationDomainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/validateConfiguration`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		l3IsolationDomainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("l3IsolationDomainName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := l.srv.BeginValidateConfiguration(req.Context(), resourceGroupNameParam, l3IsolationDomainNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginValidateConfiguration = &respr
		l.beginValidateConfiguration.add(req, beginValidateConfiguration)
	}

	resp, err := server.PollerResponderNext(beginValidateConfiguration, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		l.beginValidateConfiguration.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginValidateConfiguration) {
		l.beginValidateConfiguration.remove(req)
	}

	return resp, nil
}
