//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armhdinsight_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/hdinsight/armhdinsight"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/hdinsight/resource-manager/Microsoft.HDInsight/preview/2023-04-15-preview/examples/ListHDInsightOperations.json
func ExampleOperationsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhdinsight.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewOperationsClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.OperationListResult = armhdinsight.OperationListResult{
		// 	Value: []*armhdinsight.Operation{
		// 		{
		// 			Name: to.Ptr("Microsoft.HDInsight/register/action"),
		// 			Display: &armhdinsight.OperationDisplay{
		// 				Description: to.Ptr("Register HDInsight resource provider for the subscription"),
		// 				Operation: to.Ptr("Register HDInsight resource provider"),
		// 				Provider: to.Ptr("Microsoft.HDInsight"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.HDInsight/unregister/action"),
		// 			Display: &armhdinsight.OperationDisplay{
		// 				Description: to.Ptr("Unregister HDInsight resource provider for the subscription"),
		// 				Operation: to.Ptr("Unregister HDInsight resource provider"),
		// 				Provider: to.Ptr("Microsoft.HDInsight"),
		// 			},
		// 	}},
		// }
	}
}
