//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/costmanagement/armcostmanagement/v2"
	"net/http"
	"net/url"
	"regexp"
)

// AlertsServer is a fake server for instances of the armcostmanagement.AlertsClient type.
type AlertsServer struct {
	// Dismiss is the fake for method AlertsClient.Dismiss
	// HTTP status codes to indicate success: http.StatusOK
	Dismiss func(ctx context.Context, scope string, alertID string, parameters armcostmanagement.DismissAlertPayload, options *armcostmanagement.AlertsClientDismissOptions) (resp azfake.Responder[armcostmanagement.AlertsClientDismissResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method AlertsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, scope string, alertID string, options *armcostmanagement.AlertsClientGetOptions) (resp azfake.Responder[armcostmanagement.AlertsClientGetResponse], errResp azfake.ErrorResponder)

	// List is the fake for method AlertsClient.List
	// HTTP status codes to indicate success: http.StatusOK
	List func(ctx context.Context, scope string, options *armcostmanagement.AlertsClientListOptions) (resp azfake.Responder[armcostmanagement.AlertsClientListResponse], errResp azfake.ErrorResponder)

	// ListExternal is the fake for method AlertsClient.ListExternal
	// HTTP status codes to indicate success: http.StatusOK
	ListExternal func(ctx context.Context, externalCloudProviderType armcostmanagement.ExternalCloudProviderType, externalCloudProviderID string, options *armcostmanagement.AlertsClientListExternalOptions) (resp azfake.Responder[armcostmanagement.AlertsClientListExternalResponse], errResp azfake.ErrorResponder)
}

// NewAlertsServerTransport creates a new instance of AlertsServerTransport with the provided implementation.
// The returned AlertsServerTransport instance is connected to an instance of armcostmanagement.AlertsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAlertsServerTransport(srv *AlertsServer) *AlertsServerTransport {
	return &AlertsServerTransport{srv: srv}
}

// AlertsServerTransport connects instances of armcostmanagement.AlertsClient to instances of AlertsServer.
// Don't use this type directly, use NewAlertsServerTransport instead.
type AlertsServerTransport struct {
	srv *AlertsServer
}

// Do implements the policy.Transporter interface for AlertsServerTransport.
func (a *AlertsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AlertsClient.Dismiss":
		resp, err = a.dispatchDismiss(req)
	case "AlertsClient.Get":
		resp, err = a.dispatchGet(req)
	case "AlertsClient.List":
		resp, err = a.dispatchList(req)
	case "AlertsClient.ListExternal":
		resp, err = a.dispatchListExternal(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AlertsServerTransport) dispatchDismiss(req *http.Request) (*http.Response, error) {
	if a.srv.Dismiss == nil {
		return nil, &nonRetriableError{errors.New("fake for method Dismiss not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CostManagement/alerts/(?P<alertId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armcostmanagement.DismissAlertPayload](req)
	if err != nil {
		return nil, err
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	alertIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("alertId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Dismiss(req.Context(), scopeParam, alertIDParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Alert, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AlertsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if a.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CostManagement/alerts/(?P<alertId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	alertIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("alertId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Get(req.Context(), scopeParam, alertIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Alert, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AlertsServerTransport) dispatchList(req *http.Request) (*http.Response, error) {
	if a.srv.List == nil {
		return nil, &nonRetriableError{errors.New("fake for method List not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CostManagement/alerts`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.List(req.Context(), scopeParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AlertsResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AlertsServerTransport) dispatchListExternal(req *http.Request) (*http.Response, error) {
	if a.srv.ListExternal == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListExternal not implemented")}
	}
	const regexStr = `/providers/Microsoft\.CostManagement/(?P<externalCloudProviderType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<externalCloudProviderId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/alerts`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	externalCloudProviderTypeParam, err := parseWithCast(matches[regex.SubexpIndex("externalCloudProviderType")], func(v string) (armcostmanagement.ExternalCloudProviderType, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armcostmanagement.ExternalCloudProviderType(p), nil
	})
	if err != nil {
		return nil, err
	}
	externalCloudProviderIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("externalCloudProviderId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.ListExternal(req.Context(), externalCloudProviderTypeParam, externalCloudProviderIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AlertsResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
