//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsubscriptions

// AvailabilityZonePeers - List of availability zones shared by the subscriptions.
type AvailabilityZonePeers struct {
	// Details of shared availability zone.
	Peers []*Peers `json:"peers,omitempty"`

	// READ-ONLY; The availabilityZone.
	AvailabilityZone *string `json:"availabilityZone,omitempty" azure:"ro"`
}

// CheckResourceNameResult - Resource Name valid if not a reserved word, does not contain a reserved word and does not start
// with a reserved word
type CheckResourceNameResult struct {
	// Name of Resource
	Name *string `json:"name,omitempty"`

	// Is the resource name Allowed or Reserved
	Status *ResourceNameStatus `json:"status,omitempty"`

	// Type of Resource
	Type *string `json:"type,omitempty"`
}

// CheckZonePeersRequest - Check zone peers request parameters.
type CheckZonePeersRequest struct {
	// The Microsoft location.
	Location *string `json:"location,omitempty"`

	// The peer Microsoft Azure subscription ID.
	SubscriptionIDs []*string `json:"subscriptionIds,omitempty"`
}

// CheckZonePeersResult - Result of the Check zone peers operation.
type CheckZonePeersResult struct {
	// The Availability Zones shared by the subscriptions.
	AvailabilityZonePeers []*AvailabilityZonePeers `json:"availabilityZonePeers,omitempty"`

	// the location of the subscription.
	Location *string `json:"location,omitempty"`

	// READ-ONLY; The subscription ID.
	SubscriptionID *string `json:"subscriptionId,omitempty" azure:"ro"`
}

// ClientCheckZonePeersOptions contains the optional parameters for the Client.CheckZonePeers method.
type ClientCheckZonePeersOptions struct {
	// placeholder for future optional parameters
}

// ClientGetOptions contains the optional parameters for the Client.Get method.
type ClientGetOptions struct {
	// placeholder for future optional parameters
}

// ClientListLocationsOptions contains the optional parameters for the Client.NewListLocationsPager method.
type ClientListLocationsOptions struct {
	// placeholder for future optional parameters
}

// ClientListOptions contains the optional parameters for the Client.NewListPager method.
type ClientListOptions struct {
	// placeholder for future optional parameters
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorDefinition - Error description and code explaining why resource name is invalid.
type ErrorDefinition struct {
	// Code of the error.
	Code *string `json:"code,omitempty"`

	// Description of the error.
	Message *string `json:"message,omitempty"`
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorDetail `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// ErrorResponseAutoGenerated - Error response.
type ErrorResponseAutoGenerated struct {
	// The error details.
	Error *ErrorDefinition `json:"error,omitempty"`
}

// Location information.
type Location struct {
	// READ-ONLY; The display name of the location.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; The fully qualified ID of the location. For example, /subscriptions/00000000-0000-0000-0000-000000000000/locations/westus.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The latitude of the location.
	Latitude *string `json:"latitude,omitempty" azure:"ro"`

	// READ-ONLY; The longitude of the location.
	Longitude *string `json:"longitude,omitempty" azure:"ro"`

	// READ-ONLY; The location name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The subscription ID.
	SubscriptionID *string `json:"subscriptionId,omitempty" azure:"ro"`
}

// LocationListResult - Location list operation response.
type LocationListResult struct {
	// An array of locations.
	Value []*Location `json:"value,omitempty"`
}

// Operation - Microsoft.Resources operation
type Operation struct {
	// The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// Description of the operation.
	Description *string `json:"description,omitempty"`

	// Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`

	// Service provider: Microsoft.Resources
	Provider *string `json:"provider,omitempty"`

	// Resource on which the operation is performed: Profile, endpoint, etc.
	Resource *string `json:"resource,omitempty"`
}

// OperationListResult - Result of the request to list Microsoft.Resources operations. It contains a list of operations and
// a URL link to get the next set of results.
type OperationListResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// List of Microsoft.Resources operations.
	Value []*Operation `json:"value,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.NewListPager method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// Peers - Information about shared availability zone.
type Peers struct {
	// READ-ONLY; The availabilityZone.
	AvailabilityZone *string `json:"availabilityZone,omitempty" azure:"ro"`

	// READ-ONLY; The subscription ID.
	SubscriptionID *string `json:"subscriptionId,omitempty" azure:"ro"`
}

// ResourceName - Name and Type of the Resource
type ResourceName struct {
	// REQUIRED; Name of the resource
	Name *string `json:"name,omitempty"`

	// REQUIRED; The type of the resource
	Type *string `json:"type,omitempty"`
}

// Subscription information.
type Subscription struct {
	// The authorization source of the request. Valid values are one or more combinations of Legacy, RoleBased, Bypassed, Direct
	// and Management. For example, 'Legacy, RoleBased'.
	AuthorizationSource *string `json:"authorizationSource,omitempty"`

	// The subscription policies.
	SubscriptionPolicies *SubscriptionPolicies `json:"subscriptionPolicies,omitempty"`

	// READ-ONLY; The subscription display name.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; The fully qualified ID for the subscription. For example, /subscriptions/00000000-0000-0000-0000-000000000000.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The subscription state. Possible values are Enabled, Warned, PastDue, Disabled, and Deleted.
	State *SubscriptionState `json:"state,omitempty" azure:"ro"`

	// READ-ONLY; The subscription ID.
	SubscriptionID *string `json:"subscriptionId,omitempty" azure:"ro"`
}

// SubscriptionClientCheckResourceNameOptions contains the optional parameters for the SubscriptionClient.CheckResourceName
// method.
type SubscriptionClientCheckResourceNameOptions struct {
	// Resource object with values for resource name and resource type
	ResourceNameDefinition *ResourceName
}

// SubscriptionListResult - Subscription list operation response.
type SubscriptionListResult struct {
	// REQUIRED; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// An array of subscriptions.
	Value []*Subscription `json:"value,omitempty"`
}

// SubscriptionPolicies - Subscription policies.
type SubscriptionPolicies struct {
	// READ-ONLY; The subscription location placement ID. The ID indicates which regions are visible for a subscription. For example,
	// a subscription with a location placement Id of Public_2014-09-01 has access to Azure
	// public regions.
	LocationPlacementID *string `json:"locationPlacementId,omitempty" azure:"ro"`

	// READ-ONLY; The subscription quota ID.
	QuotaID *string `json:"quotaId,omitempty" azure:"ro"`

	// READ-ONLY; The subscription spending limit.
	SpendingLimit *SpendingLimit `json:"spendingLimit,omitempty" azure:"ro"`
}

// TenantIDDescription - Tenant Id information.
type TenantIDDescription struct {
	// READ-ONLY; The fully qualified ID of the tenant. For example, /tenants/00000000-0000-0000-0000-000000000000.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The tenant ID. For example, 00000000-0000-0000-0000-000000000000.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// TenantListResult - Tenant Ids information.
type TenantListResult struct {
	// REQUIRED; The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// An array of tenants.
	Value []*TenantIDDescription `json:"value,omitempty"`
}

// TenantsClientListOptions contains the optional parameters for the TenantsClient.NewListPager method.
type TenantsClientListOptions struct {
	// placeholder for future optional parameters
}
