// Code generated by smithy-go-codegen DO NOT EDIT.

package workspaces

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/workspaces/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Imports the specified Windows 10 or 11 Bring Your Own License (BYOL) image into
// Amazon WorkSpaces using EC2 Image Builder. The image must be an already licensed
// image that is in your Amazon Web Services account, and you must own the image.
// For more information about creating BYOL images, see [Bring Your Own Windows Desktop Licenses].
//
// [Bring Your Own Windows Desktop Licenses]: https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html
func (c *Client) ImportCustomWorkspaceImage(ctx context.Context, params *ImportCustomWorkspaceImageInput, optFns ...func(*Options)) (*ImportCustomWorkspaceImageOutput, error) {
	if params == nil {
		params = &ImportCustomWorkspaceImageInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ImportCustomWorkspaceImage", params, optFns, c.addOperationImportCustomWorkspaceImageMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ImportCustomWorkspaceImageOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ImportCustomWorkspaceImageInput struct {

	// The supported compute type for the WorkSpace image.
	//
	// This member is required.
	ComputeType types.ImageComputeType

	// The description of the WorkSpace image.
	//
	// This member is required.
	ImageDescription *string

	// The name of the WorkSpace image.
	//
	// This member is required.
	ImageName *string

	// The options for image import source.
	//
	// This member is required.
	ImageSource types.ImageSourceIdentifier

	// The infrastructure configuration ARN that specifies how the WorkSpace image is
	// built.
	//
	// This member is required.
	InfrastructureConfigurationArn *string

	// The OS version for the WorkSpace image source.
	//
	// This member is required.
	OsVersion types.OSVersion

	// The platform for the WorkSpace image source.
	//
	// This member is required.
	Platform types.Platform

	// The supported protocol for the WorkSpace image. Windows 11 does not support
	// PCOIP protocol.
	//
	// This member is required.
	Protocol types.CustomImageProtocol

	// The resource tags. Each WorkSpaces resource can have a maximum of 50 tags.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type ImportCustomWorkspaceImageOutput struct {

	// The identifier of the WorkSpace image.
	ImageId *string

	// The state of the WorkSpace image.
	State types.CustomWorkspaceImageImportState

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationImportCustomWorkspaceImageMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpImportCustomWorkspaceImage{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpImportCustomWorkspaceImage{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ImportCustomWorkspaceImage"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpImportCustomWorkspaceImageValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opImportCustomWorkspaceImage(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opImportCustomWorkspaceImage(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ImportCustomWorkspaceImage",
	}
}
