import { VerdaConfig } from "../config";
import { Dependency, GoalMatcher, RuleMatchResult } from "../core/interface";
import { ParsedPath } from "../match/interface";
export declare class AlwaysMatcher implements GoalMatcher<[string]> {
    constructor();
    private createName;
    createGoalIdFromArgs(args: string[]): {
        id: string;
        args: string[];
        execArgs: [string];
    };
    matchString(name: string): {
        id: string;
        args: string[];
        execArgs: [string];
    };
    matchGoalID(id: string, args: string[]): {
        id: string;
        args: string[];
        execArgs: [string];
    } | null;
}
export declare class ExactMatcher implements GoalMatcher<[]> {
    private readonly name;
    constructor(name: string);
    createGoalIdFromArgs(args: string[]): {
        id: string;
        args: never[];
        execArgs: [];
    };
    matchString(name: string): {
        id: string;
        args: never[];
        execArgs: [];
    } | null;
    matchGoalID(id: string, args: string[]): {
        id: string;
        args: never[];
        execArgs: [];
    } | null;
}
export declare class GlobMatcher implements GoalMatcher<string[]> {
    private readonly pattern;
    private readonly matchFunction;
    constructor(pattern: string);
    private createGoalIdFromArgsImpl;
    createGoalIdFromArgs(args: string[]): {
        id: string;
        args: string[];
        execArgs: string[];
    };
    matchString(name: string): {
        id: string;
        args: string[];
        execArgs: string[];
    } | null;
    matchGoalID(id: string, args: string[]): {
        id: string;
        args: string[];
        execArgs: string[];
    } | null;
}
export declare class MakeMatcher<K extends string[]> implements GoalMatcher<string[]> {
    private readonly nameMaker;
    constructor(nameMaker: (...args: K) => string);
    createGoalIdFromArgs(args: string[]): {
        id: string;
        args: string[];
        execArgs: string[];
    };
    matchString(): null;
    matchGoalID(id: string, args: string[]): {
        id: string;
        args: string[];
        execArgs: string[];
    } | null;
}
export declare class KindMatcherT<A> implements GoalMatcher<A> {
    private readonly prefix;
    private readonly inner;
    constructor(prefix: string, inner: GoalMatcher<A>);
    createGoalIdFromArgs(args: string[]): {
        id: string;
        args: string[];
        execArgs: A;
    };
    private wrap;
    private wrapNullable;
    matchString(name: string): {
        id: string;
        args: string[];
        execArgs: A;
    } | null;
    matchGoalID(id: string, args: string[]): {
        id: string;
        args: string[];
        execArgs: A;
    } | null;
}
export declare class PrefixMatcherT<A> implements GoalMatcher<A> {
    private readonly prefix;
    private readonly inner;
    constructor(prefix: string, inner: GoalMatcher<A>);
    createGoalIdFromArgs(args: string[]): {
        id: string;
        args: string[];
        execArgs: A;
    };
    private wrap;
    private wrapNullable;
    matchString(name: string): {
        id: string;
        args: string[];
        execArgs: A;
    } | null;
    matchGoalID(id: string, args: string[]): {
        id: string;
        args: string[];
        execArgs: A;
    } | null;
}
export declare class NoStringMatcherT<A> implements GoalMatcher<A> {
    private readonly inner;
    constructor(inner: GoalMatcher<A>);
    createGoalIdFromArgs(args: string[]): Dependency & {
        execArgs: A;
    };
    matchString(name: string): null;
    matchGoalID(id: string, args: string[]): RuleMatchResult<A>;
}
export type FileExecArgs = [ParsedPath, ...string[]];
export declare class FilePathMatcherT implements GoalMatcher<FileExecArgs> {
    private readonly cfg;
    private readonly inner;
    constructor(cfg: VerdaConfig, inner: GoalMatcher<string[]>);
    createGoalIdFromArgs(args: string[]): {
        execArgs: FileExecArgs;
        id: string;
        args: string[];
    };
    private wrap;
    private wrapNullable;
    matchString(name: string): {
        execArgs: FileExecArgs;
        id: string;
        args: string[];
    } | null;
    matchGoalID(id: string, args: string[]): {
        execArgs: FileExecArgs;
        id: string;
        args: string[];
    } | null;
}
