#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Fran Bow
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250803.2

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='fran-bow'
GAME_NAME='Fran Bow'

ARCHIVE_BASE_UNITY3D_0_NAME='fran_bow_1_0_1_unity_linux_64165.sh'
ARCHIVE_BASE_UNITY3D_0_MD5='91ff10a42e12a21a6e88794d61242d50'
ARCHIVE_BASE_UNITY3D_0_SIZE='3217937'
ARCHIVE_BASE_UNITY3D_0_VERSION='1.0.1-gog64165'
ARCHIVE_BASE_UNITY3D_0_URL='https://www.gog.com/game/fran_bow'

ARCHIVE_BASE_GAMEMAKER_0_NAME='gog_fran_bow_2.3.0.5.sh'
ARCHIVE_BASE_GAMEMAKER_0_MD5='6e3013e9c8be4d25e1815f00bc177941'
ARCHIVE_BASE_GAMEMAKER_0_SIZE='530000'
ARCHIVE_BASE_GAMEMAKER_0_VERSION='160315-gog2.3.0.5'

UNITY3D_NAME_UNITY3D='Fran Bow'
## Without the Steam library, the game crashes on launch:
##
## [Steamworks.NET] Could not load [lib]steam_api.dll/so/dylib. It's likely not in the correct location. Refer to the README for more details.
## System.DllNotFoundException: steam_api assembly:<unknown assembly> type:<unknown type> member:(null)
##   at (wrapper managed-to-native) Steamworks.NativeMethods.SteamAPI_RestartAppIfNecessary(Steamworks.AppId_t)
##   at Steamworks.SteamAPI.RestartAppIfNecessary (Steamworks.AppId_t unOwnAppID) [0x00005] in <b7e627145b354893a400544b65e7f524>:0
##   at SteamManager.Awake () [0x00061] in <d6e436cab1264acea83227e1b05c1af6>:0
UNITY3D_PLUGINS_UNITY3D='
libsteam_api.so'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_BIN_FILES_GAMEMAKER='
runner'
CONTENT_GAME_DATA_FILES_GAMEMAKER='
assets'

APP_MAIN_EXE_GAMEMAKER='runner'
APP_MAIN_ICON_GAMEMAKER='assets/icon.png'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH_UNITY3D='64'
PKG_BIN_ARCH_GAMEMAKER='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES_UNITY3D='
libc.so.6
libdl.so.2
libgcc_s.so.1
libm.so.6
libpthread.so.0
librt.so.1
libz.so.1'
PKG_BIN_DEPENDENCIES_LIBRARIES_GAMEMAKER='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libGLU.so.1
libm.so.6
libopenal.so.1
libpthread.so.0
librt.so.1
libssl.so.1.0.0
libstdc++.so.6
libX11.so.6
libXext.so.6
libXrandr.so.2
libXxf86vm.so.1
libz.so.1'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
