// This file is part of the AliceVision project.
// Copyright (c) 2016 AliceVision contributors.
// Copyright (c) 2012 openMVG contributors.
// This Source Code Form is subject to the terms of the Mozilla Public License,
// v. 2.0. If a copy of the MPL was not distributed with this file,
// You can obtain one at https://mozilla.org/MPL/2.0/.

#ifndef ALICEVISION_STL_BITMASK_H
#define ALICEVISION_STL_BITMASK_H

// Taken from boost
#define ALICEVISION_BITMASK(Bitmask)                                                                                                                 \
                                                                                                                                                     \
    inline Bitmask operator|(Bitmask x, Bitmask y)                                                                                                   \
    {                                                                                                                                                \
        return static_cast<Bitmask>(static_cast<std::int32_t>(x) | static_cast<std::int32_t>(y));                                                    \
    }                                                                                                                                                \
                                                                                                                                                     \
    inline Bitmask operator&(Bitmask x, Bitmask y)                                                                                                   \
    {                                                                                                                                                \
        return static_cast<Bitmask>(static_cast<std::int32_t>(x) & static_cast<std::int32_t>(y));                                                    \
    }                                                                                                                                                \
                                                                                                                                                     \
    inline Bitmask operator^(Bitmask x, Bitmask y)                                                                                                   \
    {                                                                                                                                                \
        return static_cast<Bitmask>(static_cast<std::int32_t>(x) ^ static_cast<std::int32_t>(y));                                                    \
    }                                                                                                                                                \
                                                                                                                                                     \
    inline Bitmask operator~(Bitmask x)                                                                                                              \
    {                                                                                                                                                \
        return static_cast<Bitmask>(~static_cast<std::int32_t>(x));                                                                                  \
    }                                                                                                                                                \
                                                                                                                                                     \
    inline Bitmask& operator&=(Bitmask& x, Bitmask y)                                                                                                \
    {                                                                                                                                                \
        x = x & y;                                                                                                                                   \
        return x;                                                                                                                                    \
    }                                                                                                                                                \
                                                                                                                                                     \
    inline Bitmask& operator|=(Bitmask& x, Bitmask y)                                                                                                \
    {                                                                                                                                                \
        x = x | y;                                                                                                                                   \
        return x;                                                                                                                                    \
    }                                                                                                                                                \
                                                                                                                                                     \
    inline Bitmask& operator^=(Bitmask& x, Bitmask y)                                                                                                \
    {                                                                                                                                                \
        x = x ^ y;                                                                                                                                   \
        return x;                                                                                                                                    \
    }

#endif  // ALICEVISION_STL_HASH_H
