#!/usr/bin/perl

#makes things work when run without install
use lib qw( ../perl-shared/blib/lib ../perl-shared/blib/arch );

#makes programm work AFTER install
use lib qw( /usr/local/rrdtool-1.0.28/lib/perl ../lib/perl );

use RRDs;
use LWP::Simple; # Part of libwww (see http://www.cpan.org)

#############

$ntopHost  = "localhost"; # Host where ntop is running
$ntopPort  = 3000;        # Port where ntop is listening for HTTP connections
$if        = "iprb0";     # Interface to monitor
$url       = "http://".$ntopHost.":".$ntopPort."/dumpTrafficData.html?language=perl&key=$if";
$sleepTime = 10;
#############

$start     = time;
$name      = "protoUsage";
$rrd       = $name.".rrd";

#############

if(!(-e $rrd)) {
  RRDs::create ($rrd, "--start",$start-1, "--step",300,
		"DS:ftp:COUNTER:600:0:U",
		"DS:http:COUNTER:600:0:U",
		"DS:X11:COUNTER:600:0:U",
		"DS:Email:COUNTER:600:0:U",
		"DS:NetBIOS:COUNTER:600:0:U",
		"DS:SNMP:COUNTER:600:0:U",
		"DS:NFS:COUNTER:600:0:U",
		"RRA:AVERAGE:0.5:1:600",
		"RRA:AVERAGE:0.5:6:700",
		"RRA:AVERAGE:0.5:24:775",
		"RRA:MAX:0.5:1:600",
		"RRA:MAX:0.5:6:700",
		"RRA:MAX:0.5:24:775"
		);
    
    $ERROR = RRDs::error;
    die "$0: unable to create `$rrd': $ERROR\n" if $ERROR;
}

while(1) {
    $content = get($url);

    if($content ne "") {
	eval($content);
	
	$a = $ntopHash{$if}{IP}{FTP}{local}+$ntopHash{$if}{IP}{FTP}{local2remote}+$ntopHash{$if}{IP}{FTP}{remote2local}+$ntopHash{$if}{IP}{FTP}{remote};
	$b = $ntopHash{$if}{IP}{HTTP}{local}+$ntopHash{$if}{IP}{HTTP}{local2remote}+$ntopHash{$if}{IP}{HTTP}{remote2local}+$ntopHash{$if}{IP}{HTTP}{remote};
	$c = $ntopHash{$if}{IP}{X11}{local}+$ntopHash{$if}{IP}{X11}{local2remote}+$ntopHash{$if}{IP}{X11}{remote2local}+$ntopHash{$if}{IP}{X11}{remote};
	$d = $ntopHash{$if}{IP}{Mail}{local}+$ntopHash{$if}{IP}{Mail}{local2remote}+$ntopHash{$if}{IP}{Mail}{remote2local}+$ntopHash{$if}{IP}{Mail}{remote};
	$e = $ntopHash{$if}{IP}{'NBios-IP'}{local}+$ntopHash{$if}{IP}{'NBios-IP'}{local2remote}+$ntopHash{$if}{IP}{'NBios-IP'}{remote2local}+$ntopHash{$if}{IP}{'NBios-IP'}{remote};
	$f = $ntopHash{$if}{IP}{SNMP}{local}+$ntopHash{$if}{IP}{SNMP}{local2remote}+$ntopHash{$if}{IP}{SNMP}{remote2local}+$ntopHash{$if}{IP}{SNMP}{remote};
	$g = $ntopHash{$if}{IP}{NFS}{local}+$ntopHash{$if}{IP}{NFS}{local2remote}+$ntopHash{$if}{IP}{NFS}{remote2local}+$ntopHash{$if}{IP}{NFS}{remote};
	
	$value = $start.":".$a.":".$b.":".$c.":".$d.":".$e.":".$f.":".$g;

	print $value."\n";
      RRDs::update $rrd, $value;
	if ($ERROR = RRDs::error) {
	    die "$0: unable to update `$rrd': $ERROR\n";
	}
    }


RRDs::graph "$name.png",
    "--title", "IP Traffic Statistics for ".$if, 
    "--start", "now-1h",
    "--end", "now",
    "--lower-limit=.1",
#    "--interlace", 
    "--imgformat","PNG",
    "--logarithmic",
    "--height=250",
    "--width=600",
    "--vertical-label","Throughtput (Bytes/sec)",
    "DEF:a=$rrd:ftp:AVERAGE",
    "DEF:b=$rrd:http:AVERAGE",
    "DEF:c=$rrd:X11:AVERAGE",
    "DEF:d=$rrd:Email:AVERAGE",
    "DEF:e=$rrd:NetBIOS:AVERAGE",
    "DEF:f=$rrd:SNMP:AVERAGE",
    "DEF:g=$rrd:NFS:AVERAGE",
    "AREA:a#FF0000: FTP     ",
    "GPRINT:a:LAST:Current \\: %8.2lf %s",
    "GPRINT:a:AVERAGE:Avg  \\: %8.2lf %s",
    "GPRINT:a:MIN:Min      \\: %8.2lf %s",
    "GPRINT:a:MAX:Max      \\: %8.2lf %s\\n",
    "STACK:b#00FF00: HTTP    ",
    "GPRINT:b:LAST:Current \\: %8.2lf %s",
    "GPRINT:b:AVERAGE:Avg  \\: %8.2lf %s",
    "GPRINT:b:MIN:Min      \\: %8.2lf %s",
    "GPRINT:b:MAX:Max      \\: %8.2lf %s\\n",
    "STACK:c#0000FF: X11     ",
    "GPRINT:c:LAST:Current \\: %8.2lf %s",
    "GPRINT:c:AVERAGE:Avg  \\: %8.2lf %s",
    "GPRINT:c:MIN:Min      \\: %8.2lf %s",
    "GPRINT:c:MAX:Max      \\: %8.2lf %s\\n",
    "STACK:d#FF00FF: Email   ",
    "GPRINT:d:LAST:Current \\: %8.2lf %s",
    "GPRINT:d:AVERAGE:Avg  \\: %8.2lf %s",
    "GPRINT:d:MIN:Min      \\: %8.2lf %s",
    "GPRINT:d:MAX:Max      \\: %8.2lf %s\\n",
    "STACK:e#FFFF00: NetBIOS ",
    "GPRINT:e:LAST:Current \\: %8.2lf %s",
    "GPRINT:e:AVERAGE:Avg  \\: %8.2lf %s",
    "GPRINT:e:MIN:Min      \\: %8.2lf %s",
    "GPRINT:e:MAX:Max      \\: %8.2lf %s\\n",
    "STACK:f#00FFFF: SNMP    ",
    "GPRINT:f:LAST:Current \\: %8.2lf %s",
    "GPRINT:f:AVERAGE:Avg  \\: %8.2lf %s",
    "GPRINT:f:MIN:Min      \\: %8.2lf %s",
    "GPRINT:f:MAX:Max      \\: %8.2lf %s\\n",
    "STACK:g#909090: NFS     ",
    "GPRINT:g:LAST:Current \\: %8.2lf %s",
    "GPRINT:g:AVERAGE:Avg  \\: %8.2lf %s",
    "GPRINT:g:MIN:Min      \\: %8.2lf %s",
    "GPRINT:g:MAX:Max      \\: %8.2lf %s\\n"
    ;

    if ($ERROR = RRDs::error) {
	print "ERROR: $ERROR\n";
    };

    sleep $sleepTime;
    $start  = time;
}
