/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: tresize.c,v 1.0 1999/07/21 19:00:18 jsquyres Exp $
 *
 *	Function:	- create a resized datatype
 *	Accepts:	- type to be resized
 *			- new lower bound
 *			- new extent
 *			- new resized type (out)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <errno.h>
#include <stdlib.h>
#include <string.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>


int
MPI_Type_create_resized(type, lb, extent, newtype)

MPI_Datatype		type;
MPI_Aint		lb;
MPI_Aint		extent;
MPI_Datatype		*newtype;

{
	MPI_Datatype	ntype;			/* new datatype */
	struct _attr	*p;			/* attribute */
	struct _attrkey	*pk;			/* key */

	lam_initerr_m();
	lam_setfunc_m(BLKMPITCREATERESIZED);

	if (type == MPI_DATATYPE_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITCREATERESIZED, lam_mkerr(MPI_ERR_TYPE, 0)));
	}

	ntype = (MPI_Datatype) malloc(sizeof(struct _dtype));
	if (ntype == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITCREATERESIZED, lam_mkerr(MPI_ERR_OTHER, errno)));
	}

	*ntype = *type;

	memset(ntype->dt_name, 0, sizeof(ntype->dt_name));
	ntype->dt_commit = 0;
	ntype->dt_uargs = 0;
	ntype->dt_refcount = 1;
	ntype->dt_f77handle = -1;
	ntype->dt_label = -1;
	ntype->dt_flags &= ~(LAM_PREDEF | LAM_DTISDUP | LAM_DTNOXADJ);
	ntype->dt_flags |= LAM_DTISRESIZE | LAM_DTHASUB | LAM_DTHASLB;
	ntype->dt_lower = lb;
	ntype->dt_upper = lb + extent;
	if (ntype->dt_upper == ntype->dt_dataup
	    	&& ntype->dt_lower == ntype->dt_datalow) {
	    ntype->dt_flags |= LAM_DTNOXADJ;
	}

	ntype->dt_uargs = (void *) type;
	type->dt_refcount++;
/*
 * Copy the key attributes.
 */
	if (type->dt_keys) {

	    ntype->dt_keys = ah_init((int4) ah_size(type->dt_keys),
		    (int4) sizeof(struct _attr),
		    (int4) MPI_KEYVAL_INVALID, INT4_NIL);

	    if (ntype->dt_keys == 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPITCREATERESIZED,
				lam_mkerr(MPI_ERR_OTHER, errno)));
	    }

	    p = ah_top(type->dt_keys);

	    while (p) {
		pk = lam_getattr(p->a_key);
		if (pk == 0) {
		    return(lam_errfunc(MPI_COMM_WORLD, BLKMPITCREATERESIZED,
			    lam_mkerr(MPI_ERR_INTERN, errno)));
		}

		if (ah_insert(ntype->dt_keys, p)) {
		    return(lam_errfunc(MPI_COMM_WORLD, BLKMPITCREATERESIZED,
					lam_mkerr(MPI_ERR_OTHER, errno)));
		}

		pk->ak_refcount++;
		p = ah_next(type->dt_keys, p);
	    }
	}

	*newtype = ntype;

        lam_resetfunc_m(BLKMPITCREATERESIZED);
	return(MPI_SUCCESS);
}
