# This class takes a string containing commands to Gnuplot
# and creates a window showing the Gnuplot

# Changing from gifs to ppms
# Remember that Gnuplot calls them pbms (which are actually kindof different)

import os
import time
import shutil
import tkFileDialog
import tkMessageBox     # For the Error Dialog
from tempfile import mkstemp

from Tkinter import *


class Gnuplot:
    def __init__(self,root,gnuplotexec,commands,title):

        self.popup=Toplevel(root)
        self.popup.focus_set()

        self.popup.title(title)
        self.title=title # do this better

        self.commands=commands
        
        self.popup.resizable(False,False)
        self.frame1=Frame(self.popup)
        self.frame1.grid()

        self.canvas2 = Canvas(self.frame1,width=650,height=490,background="blue")
        self.canvas2.pack(side=TOP)

        # Make temporary files...the Python way
        self.filedes,self.filename=mkstemp() # filedes is the "file descriptor"
        tmpcmdfile_des,tmpcmdfile=mkstemp(text=True)

        # For windows gnuplot we need to replace the backslashes with forward slashes
        # (especially if your name is noelo'~1, because then you need the double quotation marks)
        newname=""
        for x in self.filename:
            a=x
            if x=="\\":
                a='/'
            newname+=a


	# To create the examples use:
	# fullcommands='set size 0.75,0.75\nset terminal pbm small color\nset output "'+newname+'"\n'+self.commands+'exit\n'
        fullcommands='set terminal pbm small color\nset output "'+newname+'"\n'+self.commands+'exit\n'
        myfile=open(tmpcmdfile,"w")
        myfile.write(fullcommands)
        myfile.close()

	# Need to use double quotation marks for Windows where there may be
	# spaces in the filename (e.g. \Program Files\)
	mytry='"'+gnuplotexec+'" '+tmpcmdfile
        os.system(mytry) # Creates picture in self.filename

        os.close(tmpcmdfile_des) # Need to close the file descriptor before removing
        os.remove(tmpcmdfile)


        frame2=Frame(self.frame1)
        frame2.pack(side=TOP)

        try:
            self.graph=PhotoImage(file=self.filename)
            
            self.item2 = self.canvas2.create_image(7,7,anchor=NW,image=self.graph)
            Label(self.frame1,text="").pack(side=TOP)

        except TclError:
            # This happens anytime that gnuplot doesn't create a graph
            # (for some reason...e.g. bad input)
            tkMessageBox.showerror(title="The script is complaining...",
                                   message="No graph has been created. This may be due \
to a problem with your gnuplot installation or with your \
input file. Contact the author if you think GaussSum is the problem.")
            self.close()
            return
        else:
            # Only put the save button there if there's something to save
            Button(frame2,text="Save As",underline=0,command=self.save).pack(side=LEFT)         
            self.popup.bind("<Alt-s>",self.save)

        Button(frame2,text="Close",underline=0,command=self.close).pack(side=LEFT)

        frame3=Frame(self.frame1)
        frame3.pack(side=TOP)
        Label(self.frame1,text="").pack(side=TOP)
    
        self.popup.bind("<Return>",self.close)
        self.popup.bind("<Escape>",self.close)

        self.popup.bind("<Alt-c>",self.close)

        self.popup.protocol("WM_DELETE_WINDOW", self.close)



    def close(self,event=None):
        os.close(self.filedes)
        os.remove(self.filename)
        self.popup.destroy()

    def save(self,event=None):
        filename=tkFileDialog.asksaveasfilename(filetypes=[("Portable Pixel Map",".ppm")],
                                                parent=self.popup,
                                                defaultextension=".ppm"
                                                )
        if filename!="":
            if filename.find(".")==-1:
                filename=filename+".ppm"
            shutil.copyfile(self.filename,filename)
            
            self.popup.title(self.title+" - "+filename)

 


if __name__=="__main__":

    line='plot sin(x)\n'
    root=Tk()
  
    app=Gnuplot(root,line,"Test plot")
    mainloop()
    
