/*
 * (C) 1998-1999 Murat Deligonul
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
 *
 */

#include "linkedlist.h"

#include <stdio.h>
#include <stdlib.h>

/*
 * Optional last argument returns idx of last found node.
 */
__list_core::node * __list_core::find_by_idx(int idx, int * pt) const
{
    int target = 0;
    for (node * current = _first; current; current = current->next, target++)
    {
        if (target == idx)
        {
            if (pt) 
                *pt = target;
            return current;
        }
    }
    if (pt)
        *pt = target;
    return NULL;
}

__list_core::__list_core(void * init_data)
{
    _last = _first = NULL;
    num_nodes = 0;
    if (init_data)
        add(init_data);
}

/*
 * Destroy everything
 */
__list_core::~__list_core(void)
{
    while (_first)
        remove(0);
}

/*
 * Add an element to the end of the list 
 */
int __list_core::add(void * data)
{
    node * n = new node;
    if (!_first)
        _first = n;
    if (_last)
        _last->next = n;
    n->data = data;
    n->prev = _last;
    n->next = NULL;
    _last = n;
    return (++num_nodes);
}

/*
 * Insert at arbitrary position, or at
 * begining of list if none specified.
 * Takes elements place at idx. Moves that element up one.
 * Does not work for adding to an end (right now); use add() for that. 
 *
 * Return: new number of elements (0 on error)
 */
int __list_core::insert(void * data, int idx /* = 0 */)
{
    int target = 0;
    node * current = find_by_idx(idx , &target);
    if (target != idx)
        return 0;
    
    node * n = new node;
    n->data = data;

    if (current)
    {
        if (current->prev)
            current->prev->next = n;
        n->prev = current->prev;
        n->next = current;
        current->prev = n;
    }
    else {
        n->prev = NULL;
        n->next = NULL;
    }
    if (!n->prev)
        _first = n;
    if (!n->next)
        _last = n;
    return (++num_nodes);
}

/*
 * Get element[idx], but do not remove it.
 * Use remove() if you want to remove it.
 */
void * __list_core::get(int idx)
{
    node * n = find_by_idx(idx);
    return n ? n->data : NULL;
}

/*
 * Get element[idx] and remove it
 */
void * __list_core::remove(int idx)
{
    node * n = find_by_idx(idx);
    void * d;
    if (!n)
        return NULL;
    d = n->data;
    if (n->prev)
        n->prev->next = n->next;
    if (n->next)
        n->next->prev = n->prev;
    if (!n->prev)
        _first = n->next;
    if (!n->next)
        _last = n->prev;
    delete n;
    num_nodes--;
    return d;
}


bool __list_core::remove(void * data)
{
    int idx = 0;
    for (node * n = _first; n; n = n->next, idx++)
        if (n->data == data)
            return remove(idx), true;
    return false;
}

/*
 * Get the currently pointed item.
 * Optional integer argument:
 *  -1:     get previous item
 *   1:     get next item
 *   0:     get current  
 */
void *__list_iter::get(int w)
{
   if (current) 
   {
       if (w == -1 && current->prev) 
           return current->prev->data;
       else if (w == 1 && current->next)
           return current->next->data;
       return current->data;
   }
   return NULL;
}   

