/* Copyright (C) 2001 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#ifndef CONFIG_H
#define CONFIG_H
#include "config.h"
#endif


#include <unistd.h>
#include <string>
#include <fstream>

#include <gtk--/window.h>
#include <gtk--/menubar.h>
#include <gtk--/table.h>
#include <gtk--/button.h>
#include <gtk--/box.h>
#include <gtk--/entry.h>
#include <gtk--/text.h>
#include <gtk--/label.h>
#include <gtk--/frame.h>

#include "efax_controller.h"
#include "fax_list.h"
#include "pipes.h"
#include "prog_defs.h"

class MessageText: public Gtk::Table {

  std::ofstream logfile;
  std::string logfile_name;
  std::string starting_dirname;
  Gtk::Text text;
  Gtk::Text_Helpers::Context red_context;
  SigC::Connection timer_slot_connection;
  void cleanify(string&);
public:
  void write_black_slot(const char* message);
  void write_red_slot(const char* message);
  gint flush_logfile_timer_slot(void);
  void reset_logfile(void);
  MessageText(void);
  ~MessageText(void);
};

class StatusLine: public Gtk::HBox {

  Gtk::Label status_label;
  Gtk::Label flexi_label;
  Gtk::Frame status_frame;
  Gtk::Frame flexi_frame;
public:
  void write_status(const char* text) {status_label.set_text(text);}
  StatusLine(const int);
};

class MainWindow: public Gtk::Window {

  const int standard_size;
  static Pipe_fifo error_pipe;
  static bool connected_to_stderr;
  Gtk::VBox window_box;
  Gtk::Table table;
  Gtk::MenuBar menu_bar;
  Gtk::HBox file_box;
  Gtk::HBox number_box;
  Gtk::Entry file_entry;
  Gtk::Entry number_entry;
  Gtk::Button file_button;
  Gtk::Button number_button;
  Gtk::Button send_button;
  Gtk::Button receive_answer_button;
  Gtk::Button receive_takeover_button;
  Gtk::Button receive_standby_button;
  Gtk::Button stop_button;
  MessageText text_window;
  StatusLine status_line;
  EfaxController efax_controller;
  void get_file_slot(void);
  void sendfax_slot(void);
  void receive_slot(int);
  void about_slot(bool);
  void fax_list_slot(FaxListDialog::Mode);
  void addressbook_slot(void);
  void settings_slot(void);
  void settings_changed_slot(const string&);
  void helpfile_slot(void);
  void set_number(const std::string&);
  void read_error_slot(gint, GdkInputCondition);
  gint timer_event_handler(void);
protected:
  virtual gint delete_event_impl(GdkEventAny*) {return false;} // returning false causes destroy sig to be emitted
  virtual gint key_press_event_impl(GdkEventKey*);
public:
  friend ssize_t write_error(const char*);
  friend int connect_to_stderr(void);

  void destroy_slot(void);
  MainWindow(const std::string&, const char* filename = 0);
};

#endif
