/* Copyright (C) 2001 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#ifndef ADDRESSBOOK_H
#define ADDRESSBOOK_H

#ifndef CONFIG_H
#define CONFIG_H
#include "config.h"
#endif

#include <string>
#include <vector>

#include <gtk--/window.h>
#include <gtk--/table.h>
#include <gtk--/button.h>
#include <gtk--/clist.h>
#include <gtk--/scrolledwindow.h>
#include <gtk--/box.h>
#include <gtk--/entry.h>
#include <gtk--/label.h>
#include <gtk--/tooltips.h>

#include "prog_defs.h"


class AddressBook: public Gtk::Window {

  static int is_address_list;
  const int standard_size;
  Gtk::Window& parent;
  bool in_run_loop;
  Gtk::Table table;
  Gtk::Table list_table;
  Gtk::ScrolledWindow address_list_scroll_window;
  Gtk::Button add_button;
  Gtk::Button delete_button;
  Gtk::Button up_button;
  Gtk::Button down_button;
  Gtk::Button ok_button;
  Gtk::Button cancel_button;
  Gtk::CList address_list;
  Gtk::Tooltips tooltips;

  std::string result;
  void read_list(void);
  void save_list(void);
  void ok_slot(void);
  void finish(void);
  std::string get_number(void);
  void add_address_prompt(void);
  void add_address(const std::vector<std::string>& address);
  void delete_address_prompt(void);
  void delete_address(Gtk::CList_Helpers::SelectionList::iterator);
  void move_up(void);
  void move_down(void);

protected:
  virtual gint delete_event_impl(GdkEventAny*);
public:
  SigC::Signal1<void, const std::string&> accepted;

  static int get_is_address_list(void) {return is_address_list;}
  std::string run(void);

  AddressBook(const int standard_size, Gtk::Window& window);
  ~AddressBook(void);
};

class AddressDialog: public Gtk::Window {

  bool in_run_loop;
  Gtk::Button ok_button;
  Gtk::Button cancel_button;
  Gtk::HBox name_box;
  Gtk::HBox number_box;
  Gtk::Label name_label;
  Gtk::Label number_label;
  Gtk::Entry name_entry;
  Gtk::Entry number_entry;
  Gtk::Table table;
  Gtk::Window& parent;
protected:
  virtual gint delete_event_impl(GdkEventAny*);
  virtual gint key_press_event_impl(GdkEventKey*);
public:
  void selected(bool);
  SigC::Signal1<void, const std::vector<std::string>&> accepted;
  void run(void);
  AddressDialog(const int standard_size, Gtk::Window& window);
};


#endif
