/************************************************************/
/* MIDIMON.C: Midimonitor zeigt alle einkommenden Daten an  */
/*            V 1.00 (feb 91)             by wini           */
/************************************************************/
/* A) Systembibliotheken und C-Header */
#ifdef ATARI
#include <tos.h>
#endif

#include <stdlib.h>
#include	<stdio.h>

#include "mididefs.h"
#include "midi_io.h"
#include "midiparse.h"


/* D) defines */
#define MAX_ERROR_COUNT 1000

/* Schnittstelle zur Benutzerfhrung, an Platform angepasst */
void my_cmd_2byte(MIDIParser *p);
void my_cmd_3byte(MIDIParser *p);
void my_cmd_sysex(MIDIParser *p);

/* -------------------- midi_mon ----------- */
int main()

{
  byte stat;
  byte mybyte;
  int count;
  MIDIParser *p;
  MIDIPort *mp;

  puts("MIDI Monitoring");
 
  if(midi_open() <= 0){
	 fputs("could not open MIDI-DEVICE\n",stderr);
	 return -1;
  };
  
  mp = midi_getfirstport();

  puts("MIDI-Device opened");

  p = mp_parse_init(0);

  if(p == NULL){
	 fputs("Error init parser init\n",stderr);
	 return -2;
  }
 
  /* primitives */
  p->cmd_2byte = my_cmd_2byte;
  p->cmd_3byte = my_cmd_3byte;
  p->cmd_sysex = my_cmd_sysex;

  /* detailed */

  key_flush();
  midi_flush(mp);
  puts("Abbruch mit <Return>");

  count = 0; 
  while(key_instat() <=0 && count < MAX_ERROR_COUNT){

	 if( midi_instat(mp) ){

		mybyte = midi_in(mp) & 0xFF;

		if(mybyte & 0x80)
		  puts("<-");

		/*		printf("%x:",mybyte);*/
		stat = mp_parse(p,mybyte);

		if(stat == MP_ERROR)
		  printf("Error %d: %2x \n",count++,mybyte);
		  		
	 };/* midiinstat */
  };


  if(count >= MAX_ERROR_COUNT)
	 fprintf(stderr,"More than %d MIDI Errors, aborting...\n",MAX_ERROR_COUNT);
  else
	 printf("midimon:%d MIDI Errors detected\n",count);
	 

  puts("ENDE");

  midi_close();
  mp_parse_exit(p);
  key_flush();
  return 0;
}

/* ---------------  erkannte Befehle  --------- */
void my_cmd_2byte(MIDIParser *p)
{
printf("%2x(%2d)-%d\n",p->p_befehl,p->p_kanal,
			p->p_data[0]);

}

void my_cmd_3byte(MIDIParser *p)
{
  printf("%1x(%2d)-%d-%d\n",p->p_befehl,p->p_kanal,
			p->p_data[0], p->p_data[1]);
}

void my_sysex(int num,byte *data)
{
  int i;

  printf("SYSEX: (raw data)");

  for(i=0; i<num; i++){
	 if(!(i%16))
		putchar('\n');
	 printf("-%02x",data[i]);
  };
}

void my_cmd_sysex(MIDIParser *p)
{
  my_sysex(p->cmd_byte-1,p->p_data);
}


