/*
 *  Sarien AGI :: Copyright (C) 1999 Dark Fiber 
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <ctype.h>

#include "sarien.h"
#include "opcodes.h"
#include "logic.h"
#include "console.h"


#define USE_DEBUGBOX

void	debug_box(UINT16 lognum, UINT8 mode, UINT8 *str);


#define ip	(logics[lognum].cIP)
#define code	(logics[lognum].data)

#if 1 /* ifndef NO_DEBUG */
#define __L(a,b,c) { (UINT8*)a, b, c }
#else
#define __L(a,b,c) { b, c }
#endif


UINT8 debug_enabled = 0;
UINT8 debug_opcodes = 0;
UINT8 debug_logic0 = 1;
UINT32 debug_steps;


AGI_LOGICNAMES	logic_names_test[]=
{
        __L("",			0, 0x00),
        __L("equaln",		2, 0x80),
        __L("equalv",		2, 0xC0),
        __L("lessn",		2, 0x80),
        __L("lessv",		2, 0xC0),
        __L("greatern",		2, 0x80),
        __L("greaterv",		2, 0xC0),
        __L("isset",		1, 0x00),
        __L("issetv",		1, 0x80),
        __L("has",		1, 0x00),
        __L("obj.in.room",	2, 0x40),
        __L("posn",		5, 0x00),
        __L("controller",	1, 0x00),
        __L("have.key",		0, 0x00),

       	/* Not 0 args. Has variable number. */
        __L("said",		0, 0x00),

        __L("compare.strings",	2, 0x00),
        __L("obj.in.box",	5, 0x00),
        __L("center.posn",	5, 0x00),
        __L("right.posn",	5, 0x00)
};

AGI_LOGICNAMES logic_names_if[]=
{
	__L("OR",		0, 0x00),
	__L("NOT",		0, 0x00),
	__L("ELSE",		0, 0x00),
	__L("IF",		0, 0x00)
};

AGI_LOGICNAMES logic_names_cmd[]=
	{
        __L("return",		0, 0x00),	/* 00 */
        __L("increment",	1, 0x80),       /* 01 */
        __L("decrement",	1, 0x80),       /* 02 */
        __L("assignn",		2, 0x80),       /* 03 */
        __L("assignv",		2, 0xC0),       /* 04 */
        __L("addn",		2, 0x80),       /* 05 */
        __L("addv",		2, 0xC0),       /* 06 */
        __L("subn",		2, 0x80),       /* 07 */
        __L("subv",		2, 0xC0),       /* 08 */
        __L("lindirectv",	2, 0xC0),       /* 09 */
        __L("rindirect",	2, 0xC0),       /* 0A */
        __L("lindirectn",	2, 0x80),       /* 0B */
        __L("set",		1, 0x00),       /* 0C */
        __L("reset",		1, 0x00),       /* 0D */
        __L("toggle",		1, 0x00),       /* 0E */
        __L("set.v",		1, 0x80),       /* 0F */
	__L("reset.v",		1, 0x80),	/* 10 */
	__L("toggle.v",		1, 0x80),	/* 11 */
	__L("new.room",		1, 0x00),	/* 12 */
	__L("new.room.v",	1, 0x80),	/* 13 */
	__L("load.logics",	1, 0x00),	/* 14 */
	__L("load.logics.v",	1, 0x80),	/* 15 */
	__L("call",		1, 0x00),	/* 16 */
	__L("call.v",		1, 0x80),	/* 17 */
	__L("load.pic",		1, 0x80),	/* 18 */
	__L("draw.pic",		1, 0x80),	/* 19 */
	__L("show.pic",		0, 0x00),	/* 1A */
	__L("discard.pic",	1, 0x80),	/* 1B */
	__L("overlay.pic",	1, 0x80),	/* 1C */
	__L("show.pri.screen",	0, 0x00),	/* 1D */
	__L("load.view",	1, 0x00),	/* 1E */
	__L("load.view.v",	1, 0x80),	/* 1F */
	__L("discard.view",	1, 0x00),	/* 20 */
	__L("animate.obj",	1, 0x00),	/* 21 */
	__L("unanimate.all",	0, 0x00),	/* 22 */
	__L("draw",		1, 0x00),	/* 23 */
	__L("erase",		1, 0x00),	/* 24 */
	__L("position",		3, 0x00),	/* 25 */
	__L("position.v",	3, 0x60),	/* 26 */
	__L("get.posn",		3, 0x60),	/* 27 */
	__L("reposition",	3, 0x60),	/* 28 */
	__L("set.view",		2, 0x00),	/* 29 */
	__L("set.view.v",	2, 0x40),	/* 2A */
	__L("set.loop",		2, 0x00),	/* 2B */
	__L("set.loop.v",	2, 0x40),	/* 2C */
	__L("fix.loop",		1, 0x00),	/* 2D */
	__L("release.loop",	1, 0x00),	/* 2E */
	__L("set.cel",		2, 0x00),	/* 2F */
	__L("set.cel.v",	2, 0x40),	/* 30 */
	__L("last.cel",		2, 0x40),	/* 31 */
	__L("current.cel",	2, 0x40),	/* 32 */
	__L("current.loop",	2, 0x40),	/* 33 */
	__L("current.view",	2, 0x40),	/* 34 */
	__L("number.of.loops",	2, 0x40),	/* 35 */
	__L("set.priority",	2, 0x00),	/* 36 */
	__L("set.priority.v",	2, 0x40),	/* 37 */
	__L("release.priority",	1, 0x00),	/* 38 */
	__L("get.priority",	2, 0x40),	/* 39 */
	__L("stop.update",	1, 0x00),	/* 3A */
	__L("start.update",	1, 0x00),	/* 3B */
	__L("force.update",	1, 0x00),	/* 3C */
	__L("ignore.horizon",	1, 0x00),	/* 3D */
	__L("observe.horizon",	1, 0x00),	/* 3E */
	__L("set.horizon",	1, 0x00),	/* 3F */
	__L("object.on.water",	1, 0x00),	/* 40 */
	__L("object.on.land",	1, 0x00),	/* 41 */
	__L("object.on.anything",1, 0x00),	/* 42 */
	__L("ignore.objs",	1, 0x00),	/* 43 */
	__L("observe.objs",	1, 0x00),	/* 44 */
	__L("distance",		3, 0x20),	/* 45 */
	__L("stop.cycling",	1, 0x00),	/* 46 */
	__L("start.cycling",	1, 0x00),	/* 47 */
	__L("normal.cycle",	1, 0x00),	/* 48 */
	__L("end.of.loop",	2, 0x00),	/* 49 */
	__L("reverse.cycle",	1, 0x00),	/* 4A */
	__L("reverse.loop",	2, 0x00),	/* 4B */
	__L("cycle.time",	2, 0x40),	/* 4C */
	__L("stop.motion",	1, 0x00),	/* 4D */
	__L("start.motion",	1, 0x00),	/* 4E */
	__L("step.size",	2, 0x40),	/* 4F */
	__L("step.time",	2, 0x40),	/* 50 */
	__L("move.obj",		5, 0x00),	/* 51 */
	__L("move.obj.v",	5, 0x70),	/* 52 */
	__L("follow.ego",	3, 0x00),	/* 53 */
	__L("wander",		1, 0x00),	/* 54 */
	__L("normal.motion",	1, 0x00),	/* 55 */
	__L("set.dir",		2, 0x40),	/* 56 */
	__L("get.dir",		2, 0x40),	/* 57 */
	__L("ignore.blocks",	1, 0x00),	/* 58 */
	__L("observe.blocks",	1, 0x00),	/* 59 */
	__L("block",		4, 0x00),	/* 5A */
	__L("unblock",		0, 0x00),	/* 5B */
	__L("get",		1, 0x00),	/* 5C */
	__L("get.v",		1, 0x80),	/* 5D */
	__L("drop",		1, 0x00),	/* 5E */
	__L("put",		2, 0x00),	/* 5F */
	__L("put.v",		2, 0x40),	/* 60 */
	__L("get.room.v",	2, 0xC0),	/* 61 */
	__L("load.sound",	1, 0x00),	/* 62 */
	__L("sound",		2, 0x00),	/* 63 */
	__L("stop.sound",	0, 0x00),	/* 64 */
	__L("print",		1, 0x00),	/* 65 */
	__L("print.v",		1, 0x80),	/* 66 */
	__L("display",		3, 0x00),	/* 67 */
	__L("display.v",	3, 0xE0),	/* 68 */
	__L("clear.lines",	3, 0x00),	/* 69 */
	__L("text.screen",	0, 0x00),	/* 6A */
	__L("graphics",		0, 0x00),	/* 6B */
	__L("set.cursor.char",	1, 0x00),	/* 6C */
	__L("set.text.attribute",2, 0x00),	/* 6D */
	__L("shake.screen",	1, 0x00),	/* 6E */
	__L("configure.screen",	3, 0x00),	/* 6F */
	__L("status.line.on",	0, 0x00),	/* 70 */
	__L("status.line.off",	0, 0x00),	/* 71 */
	__L("set.string",	2, 0x00),	/* 72 */
	__L("get.string",	5, 0x00),	/* 73 */
	__L("word.to.string",	2, 0x00),	/* 74 */
	__L("parse",		1, 0x00),	/* 75 */
	__L("get.num",		2, 0x40),	/* 76 */
	__L("prevent.input",	0, 0x00),	/* 77 */
	__L("accept.input",	0, 0x00),	/* 78 */
	__L("set.key",		3, 0x00),	/* 79 */
	__L("add.to.pic",	7, 0x00),	/* 7A */
	__L("add.to.pic.v",	7, 0xFE),	/* 7B */
	__L("status",		0, 0x00),	/* 7C */
	__L("save.game",	0, 0x00),	/* 7D */
	__L("restore.game",	0, 0x00),	/* 7E */
	__L("init.disk",	0, 0x00),	/* 7F */
	__L("restart.game",	0, 0x00),	/* 80 */
	__L("show.obj",		1, 0x00),	/* 81 */
	__L("random",		3, 0x20),	/* 82 */
	__L("program.control",	0, 0x00),	/* 83 */
	__L("player.control",	0, 0x00),	/* 84 */
	__L("obj.status.v",	1, 0x80),	/* 85 */
	/* 0 args for AGI version 2.089 */
	__L("quit",		1, 0x00),	/* 86 */

	__L("show.mem",		0, 0x00),	/* 87 */
	__L("pause",		0, 0x00),	/* 88 */
	__L("echo.line",	0, 0x00),	/* 89 */
	__L("cancel.line",	0, 0x00),	/* 8A */
	__L("init.joy",		0, 0x00),	/* 8B */
	__L("toggle.monitor",	0, 0x00),	/* 8C */
	__L("version",		0, 0x00),	/* 8D */
	__L("script.size",	1, 0x00),	/* 8E */
	__L("set.game.id",	1, 0x00),	/* 8F */
	__L("log",		1, 0x00),	/* 90 */
	__L("set.scan.start",	0, 0x00),	/* 91 */
	__L("reset.scan.start",	0, 0x00),	/* 92 */
	__L("reposition.to",	3, 0x00),	/* 93 */
	__L("reposition.to.v",	3, 0x60),	/* 94 */
	__L("trace.on",		0, 0x00),	/* 95 */
	__L("trace.info",	3, 0x00),	/* 96 */

	/* 3 args for AGI versions before 2.440	*/
	__L("print.at",		4, 0x00),	/* 97 */
	__L("print.at.v",	4, 0x80),	/* 98 */

	__L("discard.view.v",	1, 0x80),	/* 99 */
	__L("clear.text.rect",	5, 0x00),	/* 9A */
	__L("set.upper.left",	2, 0x00),	/* 9B */
	__L("set.menu",		1, 0x00),	/* 9C */
	__L("set.menu.item",	2, 0x00),	/* 9D */
	__L("submit.menu",	0, 0x00),	/* 9E */
	__L("enable.item",	1, 0x00),	/* 9F */
	__L("disable.item",	1, 0x00),	/* A0 */
	__L("menu.input",	0, 0x00),	/* A1 */
	__L("show.obj.v",	1, 0x01),	/* A2 */
	__L("open.dialogue",	0, 0x00),	/* A3 */
	__L("close.dialogue",	0, 0x00),	/* A4 */
	__L("mul.n",		2, 0x80),	/* A5 */
	__L("mul.v",		2, 0xC0),	/* A6 */
	__L("div.n",		2, 0x80),	/* A7 */
	__L("div.v",		2, 0xC0),	/* A8 */
	__L("close.window",	0, 0x00),	/* A9 */

	__L("unknown170",	1, 0x00),	/* AA */
	__L("unknown171",	0, 0x00),	/* AB */
	__L("unknown172",	0, 0x00),	/* AC */
	__L("unknown173",	0, 0x00),	/* AD */
	__L("unknown174",	1, 0x00),	/* AE */
	__L("unknown175",	1, 0x00),	/* AF */

	/* 1 arg for AGI version 3.002.086 */
	__L("unknown176",	0, 0x00),	/* B0 */

	__L("unknown177",	1, 0x00),	/* B1 */
	__L("unknown178",	0, 0x00),	/* B2 */
	__L("unknown179",	4, 0x00),	/* B3 */
	__L("unknown180",	2, 0x00),	/* B4 */
	__L("unknown181",	0, 0x00),	/* B5 */
	__L(NULL,		0, 0x00)
};


void debug_console (UINT16 lognum, UINT8 mode, char *str)
{
	AGI_LOGICNAMES *x;
	UINT8 a, c, z;

	if (str) {
    		report ("         %s\n", str);
		return;
	}

    	report ("%03d:%04x ", lognum, ip);

	switch (*(code + ip))
	{
    	case 0xFC:
    	case 0xFD:
    	case 0xFE:
    	case 0xFF:
    		x = logic_names_if;

		if (debug_opcodes) {
			report ("%02X %02X %02X %02X %02X %02X %02X %02X %02X\n"
				"         ",
    				(UINT8)*(code + (0 + ip)) & 0xFF,
    				(UINT8)*(code + (1 + ip)) & 0xFF,
    				(UINT8)*(code + (2 + ip)) & 0xFF,
    				(UINT8)*(code + (3 + ip)) & 0xFF,
    				(UINT8)*(code + (4 + ip)) & 0xFF,
    				(UINT8)*(code + (5 + ip)) & 0xFF,
    				(UINT8)*(code + (6 + ip)) & 0xFF,
    				(UINT8)*(code + (7 + ip)) & 0xFF,
    				(UINT8)*(code + (8 + ip)) & 0xFF);
		}
		report ("%s ", (x + *(code + ip) - 0xFC)->name);
    		break;
    	default:
		x = mode == lCOMMAND_MODE ? logic_names_cmd : logic_names_test;
    		a = (x + *(code + ip))->num_args;
    		c = (x + *(code + ip))->arg_mask;

		if (debug_opcodes) {
			report("%02X %02X %02X %02X %02X %02X %02X %02X %02X\n"
				"         ",
    				(UINT8)*(code + (0 + ip)) & 0xFF,
    				(UINT8)*(code + (1 + ip)) & 0xFF,
    				(UINT8)*(code + (2 + ip)) & 0xFF,
    				(UINT8)*(code + (3 + ip)) & 0xFF,
    				(UINT8)*(code + (4 + ip)) & 0xFF,
    				(UINT8)*(code + (5 + ip)) & 0xFF,
    				(UINT8)*(code + (6 + ip)) & 0xFF,
    				(UINT8)*(code + (7 + ip)) & 0xFF,
    				(UINT8)*(code + (8 + ip)) & 0xFF);
		}
		report ("%s ", (x + *(code + ip))->name);

    		for (z = 1; a > 0; )
    		{
    			if (~c & 0x80) {
    				report ("%d", *(code+(ip+z)));
    			} else {
    				report ("v%d[%d]", *(code + (ip + z)),
					getvar (*(code + (ip + z))));
			}
    			c <<= 1;
    			z++;
    			if (--a > 0)
    				report (",");
    		}
    		break;
	}

	report ("\n");
}

