/*
 *  Sarien AGI :: Copyright (C) 1999 Dark Fiber 
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "sarien.h"
#include "agi.h"
#include "gfx.h"
#include "keyboard.h"
#include "view.h"
#include "menu.h"
#include "opcodes.h"	/* remove later */
#include "console.h"

AGI_EVENT events[MAX_DIRS];	/* keyboard events */

UINT16 num_ego_words;		/* number of words entered */
AGI_WORD ego_words[MAX_WORDS];	/* words entered by player */

UINT8 strings[MAX_WORDS1][MAX_WORDS2];	/* strings */

UINT16 key; 
UINT8  buffer[40];
UINT8  last_sentence[40];
UINT8  IsGetString=__FALSE;
UINT16  xInput, yInput;


extern UINT8 console_active;
extern UINT8 console_input_active;
extern UINT16 console_y;
extern UINT16 console_count;
extern UINT16 console_input_key;
extern UINT16 console_first_line;

/*
 * IBM-PC keyboard scancodes
 */
UINT8 scancode_table[26] =
{
	30,			/* A */
	48,			/* B */
	46,			/* C */
	32,			/* D */
	18,			/* E */
	33,			/* F */
	34,			/* G */
	35,			/* H */
	23,			/* I */
	36,			/* J */
	37,			/* K */
	38,			/* L */
	50,			/* M */
	49,			/* N */
	24,			/* O */
	25,			/* P */
	16,			/* Q */
	19,			/* R */
	31,			/* S */
	20,			/* T */
	22,			/* U */
	47,			/* V */
	17,			/* W */
	45,			/* X */
	21,			/* Y */
	44			/* Z */
};


void init_words (void)
{
	clean_input ();
}


void clean_input (void)
{
	UINT16 i;

	for (i = 0; i < MAX_WORDS; i++) {
		ego_words[i].word = null_msg;
		ego_words[i].id = 0xFFFF;
	}
	num_ego_words = 0;
}


void print_character( UINT16 x, UINT16 y, char c, int fg, int bg )
{
	if (allow_kyb_input == __TRUE)
	{
		put_text_character( 0, x, y, c, fg, bg );
		/* CM: the extra pixel in y is for the underline cursor */
		gfx->put_block (x, y, x + 7, y + 8); 
	}
}

/* Called if ego enters a new room*/
void print_line_prompt(void)
{
	UINT8 k;

	if (allow_kyb_input == __TRUE) 
	{
		/* Command prompt */
		print_text( agi_printf(strings[0], 0), 0, 0, line_user_input*8, 40, txt_fg, txt_bg );

		/* internal keyboard buffer */
		for (k = 0; buffer[k]; k++)
			print_character( (k + 1) * 8, line_user_input * 8, buffer[k], txt_fg, txt_bg );

		/* cursor prompt */
		if ( IsGetString )
			print_character( xInput + ((k + 1) * 8), yInput, txt_char, txt_fg, txt_bg );		
		else
			print_character( (k + 1) * 8, line_user_input * 8, txt_char, txt_fg, txt_bg );
	}
}

/* FR:
 * The capture of the keys is done inside of main_cycle()
 * It's safe to return last_sentence because all the functions who call get_string copy the result
 * into another buffer
 */
UINT8 *get_string (UINT16 x, UINT16 y, UINT16 len)
{
	UINT8 old_kyb_input = allow_kyb_input;
	UINT8 old_max_chars = getvar (V_max_input_chars);

	allow_kyb_input = __TRUE;
	setvar( V_max_input_chars, len );

	xInput = x;
	yInput = y;

	IsGetString = __TRUE;

	while( IsGetString )
		main_cycle(__TRUE);

	allow_kyb_input = old_kyb_input;
	setvar ( V_max_input_chars, old_max_chars );

	return (UINT8 *) last_sentence;
}


/* move_ego() shouldn't be in keyboard.c */
void move_ego (UINT8 direction)
{
	static UINT8 last_ego_dir = 0xFF;

	_D (("(%d)", direction));
	_D ((": last_ego_dir = %d", last_ego_dir));

	if ((view_table[EGO_VIEW_TABLE].flags & MOTION) != 0)
	{
		if (last_ego_dir != direction)
		{
			last_ego_dir = direction;
			view_table[EGO_VIEW_TABLE].direction = last_ego_dir;

         /* FR:
          * Set the loop (in ego view table) corresponding to this direction 
          */
         calc_direction( EGO_VIEW_TABLE );
		}
		else
		{
			/* stop ego from moving in same direction */
			last_ego_dir = 0;
		}
		setvar (V_ego_dir, last_ego_dir);
	}
}


void clean_keyboard ()
{
	clean_input ();
	setvar (V_key, key = 0);
	setflag (F_entered_cli, __FALSE);
	setflag (F_said_accepted_input, __FALSE);
	key = 0;
}


/*
 * poll_keyboard() is the raw key grabber (above the gfx driver, that is).
 * It handles console keys and insulates AGI from the console. In the main
 * loop, handle_keys() handles keyboard input and ego movement.
 */
void poll_keyboard (void)
{
	UINT16 xkey, c1;

	//key = 0x0;

	if (getvar (V_key != KEY_ENTER))
		setvar (V_key, key = 0);

	setvar (V_word_not_found, 0);

	if (!console_active || !console_input_active) {
		for (c1 = 0; c1 < MAX_DIRS; c1++)
			events[c1].occured = __FALSE;
	}

	/* If a key is ready, rip it */
	while (gfx->keypress ()) {
		xkey = gfx->get_key ();

		/* FIXME: move to console.c */
		switch (xkey) {
		case CONSOLE_ACTIVATE_KEY:
			if ((console_active = !console_active))
				build_console_layer ();
			continue;
		case CONSOLE_SWITCH_KEY:
			console_count = -1;
			if (console_y) {
				console_input_active = !console_input_active;
			}
			continue;
		case CONSOLE_SCROLLUP_KEY:
			console_count = -1;
			if (!console_y)
				continue;
			if (console_first_line > (CONSOLE_LINES_ONSCREEN / 2))
				console_first_line -=
					CONSOLE_LINES_ONSCREEN / 2;
			else
				console_first_line = 0;
			build_console_layer ();
			continue;
		case CONSOLE_SCROLLDN_KEY:
			console_count = -1;
			if (!console_y)
				continue;
			if (console_first_line < (CONSOLE_LINES_BUFFER -
				CONSOLE_LINES_ONSCREEN -
				CONSOLE_LINES_ONSCREEN / 2))
				console_first_line +=
					CONSOLE_LINES_ONSCREEN / 2;
			else
				console_first_line = CONSOLE_LINES_BUFFER -
					CONSOLE_LINES_ONSCREEN;
			build_console_layer ();
			continue;
		case CONSOLE_START_KEY:
			console_count = -1;
			if (console_y)
				console_first_line = 0;
			continue;
		case CONSOLE_END_KEY:
			console_count = -1;
			if (console_y)
				console_first_line = CONSOLE_LINES_BUFFER -
					CONSOLE_LINES_ONSCREEN;
			continue;
		}

		key = xkey;

		if (console_active && console_input_active)
			continue;

		/* For controller() */
		for (c1 = 0; c1 < MAX_DIRS; c1++) {
			switch (events[c1].event) {
			case eSCAN_CODE:
				if (events[c1].data == KEY_SCAN (key))
					events[c1].occured = __TRUE;
				break;
			case eKEY_PRESS:
				if (events[c1].data == KEY_ASCII(key) && !KEY_SCAN(key))
					events[c1].occured = __TRUE;
				break;
			}
		}
	}

	if (!KEY_ASCII (key))
		return;

	if (console_active && console_input_active) {
		console_input_key = KEY_ASCII (key);
		key = 0;
	} else {
		/*
		if (allow_kyb_input == __FALSE)
			return;
		*/

		setvar (V_key, KEY_ASCII (key));
	}
}


void handle_keys ()
{
	UINT8 *p=NULL;
	UINT16 k, c = 0;
	static UINT8  old_keyboard_status = __FALSE;
	static UINT8  new_line = 1;
	static UINT8  formated_entry[256];
	static UINT16 bufindex = 0;

	/*
	 */
	switch (k = getvar (V_key)) {
	case KEY_ENTER:
		_D (("KEY_ENTER"));
		
		/* remove all the crap from their strings */
		p = (UINT8*) buffer;
		while ( (*p == 0x20) && (*p) )	//Remove all leading spaces
			p++;

		if ( IsGetString ) {
			setvar (V_key, 0);
			strcpy((char *) last_sentence, (char *) p);

			IsGetString = __FALSE;
		} else {
			while (*p) {	
 				/* Remove a sequence of spaces */
				if ((*p == 0x20) && (*(p + 1) == 0x20)) {	
					p++;
					continue;
				}
				formated_entry[c++] = tolower( *p );
				p++;
			}
			formated_entry[c++] = 0;

			//Only treat the string if it isn't empty...
			if ( formated_entry[0] ) {
				strcpy((char *) last_sentence, (char *) formated_entry );
				dictionary_words (last_sentence);
			}
		}

		/* Clear to start a new line*/
		new_line         = 1;
		bufindex         = 0;
		buffer[bufindex] = 0;

		break;
	case KEY_ESCAPE:
		_D (("KEY_ESCAPE"));

		if (getflag (F_menus_work) == __TRUE) {
			release_sprites ();
			do_menus ();
			redraw_sprites ();
		}

		break;
	case 0x08:
       	if (!bufindex)
			break;

		   if ( IsGetString ) 
			   print_character( xInput + (bufindex + 1) * 8, yInput, txt_char, txt_bg, txt_bg );
		   else
			   print_character( (bufindex + 1) * 8, line_user_input * 8, txt_char, txt_bg, txt_bg );

       	bufindex--;
       	buffer[bufindex]=0;

		break;
	default:
        if (k >= 0x20 && k <= 0x7f && (bufindex < getvar (V_max_input_chars) - 1))
		{
			buffer[bufindex] = k;

			bufindex++;
			buffer[bufindex]=0;

			if ( IsGetString )
				print_character( xInput + (bufindex * 8), yInput, buffer[bufindex - 1], txt_fg, txt_bg );
			else
				print_character( bufindex * 8, line_user_input * 8, buffer[bufindex - 1], txt_fg, txt_bg );
		}
		break;
	}

	if (old_keyboard_status != allow_kyb_input) 
	{
		old_keyboard_status = allow_kyb_input;

		if (allow_kyb_input == __TRUE)
			print_line_prompt();
		else
			cmd_clear_lines (line_user_input, line_user_input, txt_bg);

	} 
	else
	{
		if (allow_kyb_input == __TRUE)
		{
			if ( new_line )
			{
				new_line = 0;

            /* TODO: Should handle IsGetString */

            if ( !IsGetString )
            {
				   cmd_clear_lines (line_user_input, line_user_input, txt_bg);
				   print_text( agi_printf(strings[0], 0), 0, 0, line_user_input*8, 40, txt_fg, txt_bg );
            }
			}

			/* Print txt_char */
			if ( IsGetString )
   			print_character( xInput + ((bufindex + 1) * 8), yInput, txt_char, txt_fg, txt_bg );		
			else
				print_character( (bufindex + 1) * 8, line_user_input * 8, txt_char, txt_fg, txt_bg );
		}
	}

	if (key < 0x100)
		return;

	switch (key) {
	case KEY_UP:
		move_ego (1);
		return;
	case KEY_DOWN:
		move_ego (5);
		return;
	case KEY_LEFT:
		move_ego (7);
		return;
	case KEY_RIGHT:
		move_ego (3);
		return;
	case KEY_UP_RIGHT:
		move_ego (2);
		return;
	case KEY_DOWN_RIGHT:
		move_ego (4);
		return;
	case KEY_UP_LEFT:
		move_ego (8);
		return;
	case KEY_DOWN_LEFT:
		move_ego (6);
		return;
	}
}


UINT8 wait_key ()
{
	UINT8 x;

	while(42)
	{
		main_cycle (__FALSE);

		if ((x = getvar (V_key))) 
		{
			setvar (V_key, key = 0);
			return x;
		}
	}
}
