#ifndef __SFFTOBMP_H__
#define __SFFTOBMP_H__
//
// sfftobmp.h
//
// This file is part of sffview, a program to view
// structured fax files (sff)
//
// Copyright (C) 2000 Peter Schaefer
//
// Permission to use, copy, modify, and distribute this software and its
// documentation for any purpose and without fee is hereby granted, provided
// that the above copyright notice appear in all copies. This software 
// is provided "as is" without express or implied warranty.
//
// You can contact the author by email at peter.schaefer@gmx.de.
// 
/*-RCS-Info----------------------------------------------------

$Id: sfftobmp.h,v 1.6 1999/12/19 07:47:53 peter Exp peter $

---RCS-Info--------------------------------------------------*/

#define TRUE 1
#define FALSE 0

#ifndef _MAX_PATH
#define _MAX_PATH 256
#endif

#ifndef _SIZE_PAGEBUFFER
#define _SIZE_PAGEBUFFER 100
#endif

typedef struct {
  wxUint16 code;		/* code, right justified, lsb-first, zero filled */
  wxUint16 run;			/* runlength */
	wxUint8 bits;	  /* codewidth in bits */	
} TABENTRY, *LPTABENTRY;

typedef enum {
	NEED_MAGIC,
	NEED_PAGESTART,
	NEED_PAGEHEADER,
	NEED_RECORD,
	LAST_PAGE	
} TScannerState;

typedef enum {
	NEED_WHITE,
	NEED_BLACK,
	NEED_WHITETERM,
	NEED_BLACKTERM
} TDecoderState;

typedef enum {
	NORMAL,
	WHITESKIP,
	BADLINE,
	USERINFO
} TSFFRecordType;

typedef struct{
	wxUint32 sff_id;
	wxUint8 version;
	wxUint8 reserved;
	wxUint16 user_info;
	wxUint16 num_pages;
	wxUint16 first_page;
	wxUint32 last_page;
	wxUint32 file_size;
} TSFFFileHeader;

typedef struct{
	wxUint8 vert_res;
	wxUint8 horiz_res;
	wxUint8 coding;
	wxUint8 specials;
	wxUint16 linelen;
	wxUint16 pagelen;
	wxUint32 prev_page;
	wxUint32 next_page;
} TSFFPageHeader;

typedef struct{
	TSFFRecordType type;
	wxUint16  cb;
	wxUint32 runlength;
	wxUint8 *pData;
} TSFFRecord;

typedef struct{
	wxUint32 width;
	wxUint32 height;
	off_t    filepos;	
} TSFFPage;

#pragma pack(1)

typedef struct { 
    wxUint8    bBlue; 
    wxUint8    bGreen; 
    wxUint8    bRed; 
    wxUint8    bNOP; 
} TBmpRGB;

typedef struct { 
    wxUint16    wType; 
    wxUint32   dwFileSize; 
    wxUint16    wNOP1; 
    wxUint16    wNOP2; 
    wxUint32   dwOffset; 
    wxUint32   dwBitmapSize; 
    wxUint32   dwPixelWidth; 
    wxUint32   dwPixelHeight; 
    wxUint16    wPlanes; 
    wxUint16    wCountBits;
    wxUint32   dwCompression; 
    wxUint32   dwSizeImage; 
    wxUint32   dwPixelWidthPerMeter; 
    wxUint32   dwPixelHeightPerMeter; 
    wxUint32   dwUsedColors;
    wxUint32   dwImportantColors; 
		TBmpRGB sCol1;
		TBmpRGB sCol2;
} TBitMapFileHeader; 

#pragma pack()

//-----------------------------------------------------------------

class CBitSource
{
protected:
	wxUint8 *m_pBuffer;

	wxUint16	m_wBitsAvail;
  wxUint32	m_dwAccu;
	wxUint32 m_dwByteCount;

public:
	void NeedBits(int nCount);
	void ClrBits(int nCount);
	wxUint16 GetBits(int nCount);

	CBitSource(void *pBuffer, wxUint32 nByteCount);
};

//-----------------------------------------------------------------

class CBitSink
{
protected:
	wxUint8 *m_pBuffer;
	
	wxUint16	m_wBitsAvail;
	wxUint32 m_dwByteCount;

public:
	void SetBits(int nCount);	
	void ClearBits(int nCount);
	
	CBitSink(void *pBuffer, wxUint32 nByteCount);
};

//-----------------------------------------------------------------

class CHuffDecoder : public CBitSource 
{
protected:
	wxUint32	m_dwRunlength;

public:
	CHuffDecoder(wxUint8 *pBuffer, wxUint32 nByteCount) : 
		CBitSource(pBuffer, nByteCount) { /* sonst nix */ };

	int	FindToken(LPTABENTRY pTable);
	int DecodeLine(CBitSink& aBitSink);
};

//-----------------------------------------------------------------

class CSimpleException
{
public:
	enum {
		err_invalidfile,
		err_corruptfile,
		err_lastpageread,
		err_notsupported,
		err_openfile,
		err_nowhitestart,
		err_noblackcode,
		err_noblackterm,
		err_nowhiteterm,
		err_invalidversion,
		err_unknowncoding
	};

	int	m_nError;
	
	CSimpleException(const int nError) :
		m_nError(nError) { };

	char * GetReason();
};

//-----------------------------------------------------------------

class CSffFile 
{
protected:
	static wxUint8 m_SFFID[4];

	wxFileInputStream m_stream;
	
	TSFFPage *m_acPages[_SIZE_PAGEBUFFER];
	int				m_nPageCount;
			
	void ScanFile();
		// throw CSimpleException

public:
	CSffFile(const wxString& strFileName);
	~CSffFile();
	
	bool 	SeekPage(int nPage);	
	wxUint32	GetPageHeight(int nPage);
	wxUint32 GetPageWidth(int nPage);
	
	bool  GetRecord(TSFFRecord& rec);
	bool 	DecodeRecord(TSFFRecord& rec, wxUint8 *pBuf, wxUint32 cbBuf);	

	int   GetPageCount() { return m_nPageCount; };

};

#endif // __SFFTOBMP_H__
