/*
 * This game is distributed under the GNU GENERAL PUBLIC LICENSE
 * version 2. See COPYING for details.
 * 
 * Copyright (C) 1999, 2000 Harry Storbacka <harrysto@nic.fi> 
*/
 
#include <ClanLib/core.h>
#include <ClanLib/display.h>
#include "race_text.h"

CL_String RaceText::read_line_get_base_name(CL_InputSource* in)
{
	CL_String ret;
	static char c[2] = { 0, 0 };

	do
	{
		c[0] = in->read_char8();
		switch( c[0] )
		{
		 case 13:
			c[0] = in->read_char8();
		 break;
		 case 10:
		 break;
		 case 46:
			while ( c[0] != 10 )
			{
				c[0] = in->read_char8(); // next line 
			}
		 break;
		 default:
			ret += c;
	     break;
		}
	} while( c[0] != 10 );
	return ret;
}




CL_String RaceText::read_line( CL_InputSource* in )
{
	CL_String ret;
	static char c[2] = { 0, 0 };

	do
	{
		c[0] = in->read_char8();
		switch( c[0] )
		{
		 case 13:
			c[0] = in->read_char8();
		 break;
		 case 10:
		 break;
		 default:
			ret += c;
	     break;
		}
	} while( c[0] != 10 );
	return ret;
}
