/*
 * Ripped from clanlib and slightly modified.
 * ClanLib's begin_2d() uses glPushAttrib(GL_ALL_ATTRIB_BITS)
 * which is a very costy call on some graphics cards.
 * (at least on my Matrox G400). While ClanLib must be general purpose
 * we know exactly what modes need to be saved, so that's why these functions
 * are used.
 */

#include <ClanLib/display.h>
#include <ClanLib/gl.h>
#include "race_opengl.h"
#include "game_config.h"

int Race_OpenGL::uses_count = 0;

void Race_OpenGL::begin_2d()
{
	glDisable(GL_DEPTH_TEST);
		
	glColor4f(1.0, 1.0, 1.0, 1.0);
		
	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
		
	short width = CL_Display::get_width();
	short height = CL_Display::get_height();
		
//	gluOrtho2D(0.0f, 640.0f, 480.0f, 0.0f);
	gluOrtho2D(0.0f, Config::screen_width, Config::screen_height, 0.0f);
	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
	glLoadIdentity();
}

void Race_OpenGL::end_2d()
{
	glPopMatrix();
	glMatrixMode(GL_PROJECTION);
	glPopMatrix();

	glEnable(GL_DEPTH_TEST);
}
