#include <ClanLib/core.h>
#include <ClanLib/display.h>
#include <ClanLib/gl.h>
#include <ClanLib/gui.h>

#ifdef WIN32
	#pragma warning (disable:4355)
#endif

#include "../menu_gfx.h"
#include "../../game_config.h"
#include "../../debug.h"
#include "options_sound.h"

OptionsSound::OptionsSound(CL_Component *parent, CL_StyleManager *style)
:
	CL_Component(
			CL_Rect(145, 150, CL_Display::get_width()-20, CL_Display::get_height()-20),
			parent,
			style),
		check_sound( CL_Point(10,20), "Sound Effects", this, style),
		check_music( CL_Point(10,50), "Music", this, style)
{
	RaceDebug::print( "OptionsSound: constructor", 9 );

	slots.connect( sig_paint(), this, &OptionsSound::on_paint );
	slots.connect( check_sound.sig_clicked(), this, &OptionsSound::on_sound);
	slots.connect( check_music.sig_clicked(), this, &OptionsSound::on_music);

	check_sound.set_checked( Config::sfx_on );
	check_music.set_checked( Config::music_on );
}


void OptionsSound::on_paint()
{
	MenuGfx::submenu_frame_bg->put_screen(0,0);
}

void OptionsSound::on_sound()
{
	Config::sfx_on = check_sound.is_checked();
	cout << "sound in now " << Config::sfx_on << endl;
}

void OptionsSound::on_music()
{
	Config::music_on = check_music.is_checked();
	cout << "music in now " << Config::music_on << endl;
}

