#include <ClanLib/core.h>
#include <ClanLib/display.h>
#include <ClanLib/gl.h>
#include <ClanLib/gui.h>

#ifdef WIN32
	#pragma warning (disable:4355)
#endif

#include "../music.h"
#include "mainmenu.h"
#include "menu_gfx.h"

#include "options/options_menu.h"
#include "track_menu.h"
#include "credits_menu.h"

MainMenu::MainMenu(CL_Component *parent, CL_StyleManager *style)
:
	CL_Component(
			CL_Rect(0, 0, CL_Display::get_width(), CL_Display::get_height()),
			parent,
			style),
		btn_start  ( CL_Rect(400 - 60, 270, 400 + 60, 270 + 30), "Start Race", this, style ),
		btn_options( CL_Rect(400 - 60, 300, 400 + 60, 300 + 30), "Options",    this, style ),
		btn_credits( CL_Rect(400 - 60, 330, 400 + 60, 330 + 30), "Credits",    this, style ),

		btn_quit   ( CL_Rect(800-20-120, 600-20-30, 800-20, 600-20), "Quit",       this, style )
{
	slots.connect( sig_paint(), this, &MainMenu::on_paint );
	slots.connect( btn_quit.sig_clicked(), this, &MainMenu::on_quit );
	slots.connect( btn_start.sig_clicked(), this, &MainMenu::on_start );
	slots.connect( btn_options.sig_clicked(), this, &MainMenu::on_options );
	slots.connect( btn_credits.sig_clicked(), this, &MainMenu::on_credits );

	if( Music::load_track(20) )
		Music::play_track();

	glEnable(GL_BLEND);
}


MainMenu::~MainMenu()
{
}

void MainMenu::on_paint()
{
	MenuGfx::bg->put_screen(0,0);
	// cout << "mainmenu::paint" << endl;

	Music::update();
}

void MainMenu::on_start()
{
	show(false);
	enable(false);

	TrackMenu track_menu( NULL, get_style_manager() );
	track_menu.run();

	// season.start() // or something like that

	enable();
	show();
}

void MainMenu::on_quit()
{
	cout << "quit" << endl;
	quit();
}

void MainMenu::on_options()
{
	cout << "options" << endl;

	show(false);
	enable(false);

	OptionsMenu opt( NULL, get_style_manager() );
	opt.run();

	enable();
	show();
}

void MainMenu::on_credits()
{
	cout << "credits" << endl;

	show(false);
	enable(false);

	CreditsMenu credits( NULL, get_style_manager() );
	credits.run();

	enable();
	show();
}


