//  Original version of this file ripped from
//
//  Pingus - A free Lemmings clone
//  Copyright (C) 1999 Ingo Ruhnke <grumbel@gmx.de>
//
//  Some small modifications made by Harry Storbacka to 
//  make it work in Race. Thanks Ingo!

#ifndef BLITTER_HH
#define BLITTER_HH

#include <ClanLib/core.h>

/** A bunch of blitting and creation functions to operate on
    CL_Canvas.  Some of them are similar to the ones in ClanLib, but
    these are slower and work. */

class Blitter
{
private:
	static void put_surface_8bit(CL_Canvas*, CL_SurfaceProvider*,
			       int x, int y);

	static void put_surface_32bit(CL_Canvas*, CL_SurfaceProvider*,
			       int x, int y);
	static void put_surface_32bit_no_blending(CL_Canvas*, CL_SurfaceProvider*,
			       int x, int y);

 public:

	/// Puts a given surface to a given canvas at position x, y.
	static void put_surface(CL_Canvas*, CL_Surface*,
			  int x, int y);

	static void put_surface_no_blending(CL_Canvas*, CL_Surface*,
			  int x, int y);

	/// Puts a given surface provider to a given canvas at position x, y.
	static void put_surface(CL_Canvas*, CL_SurfaceProvider*,
			  int x, int y);

	/** Makes all pixels in canvas tranparent, when their indexed value
	  in provider is larger than zero.*/
	static void put_alpha_surface(CL_Canvas* canvas, CL_SurfaceProvider* provider,
				int x, int y);

	/** Returns a newly allocated canvas. The canvas contains the same
	  image as the given surface. */
	static CL_Canvas* create_canvas(CL_Surface*);

	/** Returns a newly allocated canvas. The canvas contains the same
	    image as the given surface provider */
	static CL_Canvas* create_canvas(CL_SurfaceProvider*);

	/** Sets all pixels of a canvas to zero */
	static CL_Canvas* clear_canvas(CL_Canvas*);
  
	/** Creates a new surface (based on a canvas) with the given width
		and height and stretches the source surface onto it

		@param sur The source surface
		@param width The new width of the surface. 
		@param height The new height of the surface. 
		@return A newly created surface, the caller is responsible to delete it. */
	static CL_Surface* scale_surface (CL_Surface* sur, int width, int height);

	/** Creates a new canvas with the given width and height and
		stretches the source surface onto it

		@param sur The source surface
		@param width The new width of the surface. 
		@param height The new height of the surface. 
		@return A newly created surface, the caller is responsible to delete it. */
	static CL_Canvas* Blitter::scale_surface_to_canvas (CL_Surface* sur, int width, int height);


	static CL_Canvas* convert_to_32_bpp(CL_SurfaceProvider*);
	static CL_Surface* convert_to_32_bpp(CL_Surface*);


	static void texture_fill( CL_Canvas *dest, CL_Surface *src );
	static void texture_fill_mirror( CL_Canvas *dest, CL_Surface *src );

	static void ckey_texture_fill( CL_Canvas *dest, CL_Surface *src, float, float, float );
};

#endif 

/* EOF */
