/***************************************************************************
 $RCSfile: cmdlineoptions.cpp,v $
                             -------------------
    cvs         : $Id: cmdlineoptions.cpp,v 1.6 2003/04/25 01:45:53 aquamaniac Exp $
    begin       : Sat Dec 15 2001
    copyright   : (C) 2001 by Martin Preuss
    email       : martin@aquamaniac.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef __declspec
# if BUILDING_DLL
#  define DLLIMPORT __declspec (dllexport)
# else /* Not BUILDING_DLL */
#  define DLLIMPORT __declspec (dllimport)
# endif /* Not BUILDING_DLL */
#else
# define DLLIMPORT
#endif


/*
 */

#include <stdio.h>
#include "assert.h"

#include "openhbci/cmdlineoptions.h"
#include "openhbci/parser.h"
#include "openhbci/hbcistring.h"

namespace HBCI {

CmdLineOptions::CmdLineOptions():SimpleConfig(){
}


CmdLineOptions::~CmdLineOptions(){
}


Error CmdLineOptions::parseOptions(int argc, char **argv,
                                       s_CmdLineOptionDescr *od){
  Tree<ConfigNode>::iterator iter;
  int i;
  string tmp;
  string opt;
  string arg;
  string argpart;
  Error err;
  unsigned int pos;
  s_CmdLineOptionDescr *tmpod;

  // get the program name
  _cmdname=argv[0];
  // start with arg 1
  i=1;
  while(i<argc) {
    opt.erase();
    arg.erase();
    tmp=argv[i];
    i++;
    if (tmp.length()>1) {
      if (tmp.at(0)=='-') {
        if (tmp.at(1)=='-') {
          // long option
          pos=2;
          // get option
          err=parser::getString(tmp,opt,"=","''",pos);
          if (!err.isOk())
            return err;
          // get argument, if any
          if (pos+1<tmp.length())
            arg=tmp.substr(pos+1);
          else
            arg.erase();
          // find option
          tmpod=od;
          while(tmpod) {
            if (-1!=parser::cmpPattern(opt,
                                         tmpod->longOption,
                                         true))
              break;
            // loop end
            if (tmpod->flags & CLO_FLAGS_LAST)
              tmpod=0;
            else
              tmpod++;
          } // while
        }
        else {
          // short option
          opt=tmp.substr(1);
          // find option
          tmpod=od;
          while(tmpod) {
            if (-1!=parser::cmpPattern(opt,
                                         tmpod->shortOption,
                                         true))
              break;
            // loop end
            if (tmpod->flags & CLO_FLAGS_LAST)
              tmpod=0;
            else
              tmpod++;
          } // while
          // get arg if any
          arg.erase();
          if (tmpod && i<argc) {
            arg=argv[i];
            // check if it is not an option
            if (arg.length()>1) {
              if (arg.at(0)=='-')
                // it is an option, not an argument
                arg.erase();
              else
                // otherwise it is an argument
                i++;
            } // end of check for option
          } // end of argument retrieval
        } // end of short option
        // now tmpod, opt and arg are set

        // did we find the option ?
        if (!tmpod)
          return Error("CmdLineOptions::parseOptions()",
                         ERROR_LEVEL_NORMAL,
                         0,
                         ERROR_ADVISE_DONTKNOW,
                         "unknown option " + opt);
        // check if we have an unexpected argument
        if (!arg.empty() && !(tmpod->flags & CLO_FLAGS_HAS_ARGUMENT))
          return Error("CmdLineOptions::parseOptions()",
                         ERROR_LEVEL_NORMAL,
                         0,
                         ERROR_ADVISE_DONTKNOW,
                         "option "+opt+" must not have an argument");
        // check if we have no argument but need one
        if (arg.empty() && (tmpod->flags & CLO_FLAGS_HAS_ARGUMENT))
          return Error("CmdLineOptions::parseOptions()",
                         ERROR_LEVEL_NORMAL,
                         0,
                         ERROR_ADVISE_DONTKNOW,
                         "option "+opt+" needs an argument");
        // look if we have a variable of that kind
        iter=findVariable(tmpod->name,root());
        if (iter.isValid() && !(tmpod->flags & CLO_FLAGS_MULTIPLE))
          return Error("CmdLineOptions::parseOptions()",
                         ERROR_LEVEL_NORMAL,
                         0,
                         ERROR_ADVISE_DONTKNOW,
                         "option "+opt+" given multiple times");
        // create var if it does not exist
        if (!iter.isValid())
          iter=createVar(tmpod->name,root());
        // add argument, if any
        if (!arg.empty())
          iter.addChild(ConfigValue(arg));
        // that's it
      }
      else {
        // else it is just a value
        iter=root();
        iter.addChild(ConfigValue(tmp));
      }
    } // end of handling of options
    else {
      // if length<2 then it is just a value
      iter=root();
      iter.addChild(ConfigValue(tmp));
    }
  } // while
  // ok, if we reached this point then all is ok.
  return Error();
}


string CmdLineOptions::usage(s_CmdLineOptionDescr *od){
    s_CmdLineOptionDescr *tmpod;
    string result;
    string line;
    unsigned int i;
    unsigned int j;
    bool hasS;

    tmpod=od;
    while(tmpod) {
        hasS=false;
        line=" ";
        if (!(strlen(tmpod->shortOption)==0)) {
            line+="-";
            line+=string(tmpod->shortOption);
            if (tmpod->flags & CLO_FLAGS_HAS_ARGUMENT)
                line+=" <ARG>";
            line+=" ";
            hasS=true;
        }
        if (!(strlen(tmpod->longOption)==0)) {
            if (hasS)
                line+=" OR ";
            line+="--";
            line+=string(tmpod->longOption);
            if (tmpod->flags & CLO_FLAGS_HAS_ARGUMENT)
                line+="=<ARG>";
            line+=" ";
        }
        j=line.length();
        if (line.length()<40)
            for (i=0; i<(40-j); i++)
                line+=" ";
        line+=string(tmpod->description);
        line+="\n";
        result+=line;
        // loop end
        if (tmpod->flags & CLO_FLAGS_LAST)
            tmpod=0;
        else
            tmpod++;
    } // while
    return result;
}

} // namespace HBCI

HBCI_CmdLineOptions*
HBCI_CmdLineOptions_new() {
    return new HBCI_CmdLineOptions();
};

HBCI_Error* 
HBCI_CmdLineOptions_parseOptions(HBCI_CmdLineOptions* c, 
			      int argc, 
			      char **argv, 
			      s_CmdLineOptionDescr *od) {
    assert(c);
    return new HBCI_Error(c->parseOptions(argc, argv, od));
}

int 
HBCI_CmdLineOptions_findVariableIsValid(HBCI_CmdLineOptions* c, 
				     const char* path) {
    assert(c);
    return c->findVariable(path, c->root()).isValid();
}

int 
HBCI_CmdLineOptions_getIntVariable(HBCI_CmdLineOptions* c, 
				const char* name,
				int defval) {
    assert(c);
    return c->getIntVariable(name, defval, c->root());
}

char* 
HBCI_CmdLineOptions_getStringVariable(HBCI_CmdLineOptions* c,
			    const char* name, 
			    const char* defval) {
    assert(c);
    return 
	hbci_strdup(
	    c->getVariable(name, defval, c->root()));
}

char*
HBCI_CmdLineOptions_usage(HBCI_CmdLineOptions* c,
                     s_CmdLineOptionDescr *od) {
    assert(c);
    return hbci_strdup( c->usage(od) );
}
