.TH DGEGS l "15 June 2000" "LAPACK version 3.0" ")"
.SH NAME
DGEGS - routine is deprecated and has been replaced by routine DGGES
.SH SYNOPSIS
.TP 18
SUBROUTINE DGEGS(
JOBVSL, JOBVSR, N, A, LDA, B, LDB, ALPHAR,
ALPHAI, BETA, VSL, LDVSL, VSR, LDVSR, WORK,
LWORK, INFO )
.TP 18
.ti +4
CHARACTER
JOBVSL, JOBVSR
.TP 18
.ti +4
INTEGER
INFO, LDA, LDB, LDVSL, LDVSR, LWORK, N
.TP 18
.ti +4
DOUBLE
PRECISION A( LDA, * ), ALPHAI( * ), ALPHAR( * ),
B( LDB, * ), BETA( * ), VSL( LDVSL, * ),
VSR( LDVSR, * ), WORK( * )
.SH PURPOSE
This routine is deprecated and has been replaced by routine DGGES. 
DGEGS computes for a pair of N-by-N real nonsymmetric matrices A, B:
the generalized eigenvalues (alphar +/- alphai*i, beta), the real
Schur form (A, B), and optionally left and/or right Schur vectors
(VSL and VSR).
.br

(If only the generalized eigenvalues are needed, use the driver DGEGV
instead.)
.br

A generalized eigenvalue for a pair of matrices (A,B) is, roughly
speaking, a scalar w or a ratio  alpha/beta = w, such that  A - w*B
is singular.  It is usually represented as the pair (alpha,beta),
as there is a reasonable interpretation for beta=0, and even for
both being zero.  A good beginning reference is the book, "Matrix
Computations", by G. Golub & C. van Loan (Johns Hopkins U. Press)

The (generalized) Schur form of a pair of matrices is the result of
multiplying both matrices on the left by one orthogonal matrix and
both on the right by another orthogonal matrix, these two orthogonal
matrices being chosen so as to bring the pair of matrices into
(real) Schur form.
.br

A pair of matrices A, B is in generalized real Schur form if B is
upper triangular with non-negative diagonal and A is block upper
triangular with 1-by-1 and 2-by-2 blocks.  1-by-1 blocks correspond
to real generalized eigenvalues, while 2-by-2 blocks of A will be
"standardized" by making the corresponding elements of B have the
form:
.br
        [  a  0  ]
.br
        [  0  b  ]
.br

and the pair of corresponding 2-by-2 blocks in A and B will
have a complex conjugate pair of generalized eigenvalues.

The left and right Schur vectors are the columns of VSL and VSR,
respectively, where VSL and VSR are the orthogonal matrices
which reduce A and B to Schur form:
.br

Schur form of (A,B) = ( (VSL)**T A (VSR), (VSL)**T B (VSR) )

.SH ARGUMENTS
.TP 8
JOBVSL  (input) CHARACTER*1
= 'N':  do not compute the left Schur vectors;
.br
= 'V':  compute the left Schur vectors.
.TP 8
JOBVSR  (input) CHARACTER*1
.br
= 'N':  do not compute the right Schur vectors;
.br
= 'V':  compute the right Schur vectors.
.TP 8
N       (input) INTEGER
The order of the matrices A, B, VSL, and VSR.  N >= 0.
.TP 8
A       (input/output) DOUBLE PRECISION array, dimension (LDA, N)
On entry, the first of the pair of matrices whose generalized
eigenvalues and (optionally) Schur vectors are to be
computed.
On exit, the generalized Schur form of A.
Note: to avoid overflow, the Frobenius norm of the matrix
A should be less than the overflow threshold.
.TP 8
LDA     (input) INTEGER
The leading dimension of A.  LDA >= max(1,N).
.TP 8
B       (input/output) DOUBLE PRECISION array, dimension (LDB, N)
On entry, the second of the pair of matrices whose
generalized eigenvalues and (optionally) Schur vectors are
to be computed.
On exit, the generalized Schur form of B.
Note: to avoid overflow, the Frobenius norm of the matrix
B should be less than the overflow threshold.
.TP 8
LDB     (input) INTEGER
The leading dimension of B.  LDB >= max(1,N).
.TP 8
ALPHAR  (output) DOUBLE PRECISION array, dimension (N)
ALPHAI  (output) DOUBLE PRECISION array, dimension (N)
BETA    (output) DOUBLE PRECISION array, dimension (N)
On exit, (ALPHAR(j) + ALPHAI(j)*i)/BETA(j), j=1,...,N, will
be the generalized eigenvalues.  ALPHAR(j) + ALPHAI(j)*i,
j=1,...,N  and  BETA(j),j=1,...,N  are the diagonals of the
complex Schur form (A,B) that would result if the 2-by-2
diagonal blocks of the real Schur form of (A,B) were further
reduced to triangular form using 2-by-2 complex unitary
transformations.  If ALPHAI(j) is zero, then the j-th
eigenvalue is real; if positive, then the j-th and (j+1)-st
eigenvalues are a complex conjugate pair, with ALPHAI(j+1)
negative.

Note: the quotients ALPHAR(j)/BETA(j) and ALPHAI(j)/BETA(j)
may easily over- or underflow, and BETA(j) may even be zero.
Thus, the user should avoid naively computing the ratio
alpha/beta.  However, ALPHAR and ALPHAI will be always less
than and usually comparable with norm(A) in magnitude, and
BETA always less than and usually comparable with norm(B).
.TP 8
VSL     (output) DOUBLE PRECISION array, dimension (LDVSL,N)
If JOBVSL = 'V', VSL will contain the left Schur vectors.
(See "Purpose", above.)
Not referenced if JOBVSL = 'N'.
.TP 8
LDVSL   (input) INTEGER
The leading dimension of the matrix VSL. LDVSL >=1, and
if JOBVSL = 'V', LDVSL >= N.
.TP 8
VSR     (output) DOUBLE PRECISION array, dimension (LDVSR,N)
If JOBVSR = 'V', VSR will contain the right Schur vectors.
(See "Purpose", above.)
Not referenced if JOBVSR = 'N'.
.TP 8
LDVSR   (input) INTEGER
The leading dimension of the matrix VSR. LDVSR >= 1, and
if JOBVSR = 'V', LDVSR >= N.
.TP 8
WORK    (workspace/output) DOUBLE PRECISION array, dimension (LWORK)
On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
.TP 8
LWORK   (input) INTEGER
The dimension of the array WORK.  LWORK >= max(1,4*N).
For good performance, LWORK must generally be larger.
To compute the optimal value of LWORK, call ILAENV to get
blocksizes (for DGEQRF, DORMQR, and DORGQR.)  Then compute:
NB  -- MAX of the blocksizes for DGEQRF, DORMQR, and DORGQR
The optimal LWORK is  2*N + N*(NB+1).

If LWORK = -1, then a workspace query is assumed; the routine
only calculates the optimal size of the WORK array, returns
this value as the first entry of the WORK array, and no error
message related to LWORK is issued by XERBLA.
.TP 8
INFO    (output) INTEGER
= 0:  successful exit
.br
< 0:  if INFO = -i, the i-th argument had an illegal value.
.br
= 1,...,N:
The QZ iteration failed.  (A,B) are not in Schur
form, but ALPHAR(j), ALPHAI(j), and BETA(j) should
be correct for j=INFO+1,...,N.
> N:  errors that usually indicate LAPACK problems:
.br
=N+1: error return from DGGBAL
.br
=N+2: error return from DGEQRF
.br
=N+3: error return from DORMQR
.br
=N+4: error return from DORGQR
.br
=N+5: error return from DGGHRD
.br
=N+6: error return from DHGEQZ (other than failed
iteration)
=N+7: error return from DGGBAK (computing VSL)
.br
=N+8: error return from DGGBAK (computing VSR)
.br
=N+9: error return from DLASCL (various places)
