(defrule push-value
 ?push-value <- (push-value ?name ?value)
 ?stack <- (stack ?name $?rest)
=>
 (retract ?push-value ?stack)
 (assert (stack ?name ?value $?rest))
 (printout t "Pushing value " ?value " from stack " ?name crlf))
 
 (defrule pop-value-valid
  ?pop-value <- (pop-value ?name)
  ?stack <- (stack ?name ?value $?rest)
 =>
  (retract ?pop-value ?stack)
  (assert (stack ?name $?rest))
  (printout t "Popping value " ?value " from stack " ?name crlf))  

(defrule pop-value-invalid
 ?pop-value <- (pop-value ?name)
 (stack ?name)
=>
 (retract ?pop-value)
 (printout t "Attempting to pop an empty stack: " ?name crlf))
 
(deffacts initial-setup
 (stack letters a b c)    ; initial stacks
 (stack numbers 1 2)
 (push-value letters d)   ; initial actions on stacks
 (pop-value numbers)
)