/***************************************************************************
                          gui_playlist.h  -  description
                             -------------------
    begin                : Thu Mar 7 2002
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de

    This file contributed by Tim Lee ;)
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GUI_PLAYLIST_H
#define GUI_PLAYLIST_H

#include "prokyon.h"
#include "configuration.h"

#include "lvi_playlist.h"
#include "lvi_playlisttrack.h"

#include <qframe.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qptrlist.h>
#include <qlistview.h>
#include <qtabwidget.h>
#include <qspinbox.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qsplitter.h>
#include <qevent.h>

class GUI_Playlist : public QTabWidget  {
  Q_OBJECT
 public: 
  GUI_Playlist(QWidget *parent, const char *name=0);
  
  ~GUI_Playlist();

  void setConnectionState(bool state);

  void notifyNewPlaylistBasis(QList<PLAYLIST> *play_list);
  void notifyNewPlaylistTracksBasis(QList<PLAYLIST_TRACK> *tracks_list, int playlistID);
  void notifyNewPlaylist(PLAYLIST *playlist, bool isNewCreated=false);
  void notifyNewPlaylistTrack(PLAYLIST_TRACK *pl_track, int playlistID);

  void notifyRemovePlaylist(LVI_Playlist *playlist);
  void notifyRemovePlaylistTracks(QList<TRACK> *list, int playlistID);
  void notifyRemovePlaylistTracks(QList<LVI_PlaylistTrack> *pl_track_list);

  void notifyRenamePlaylist(LVI_Playlist *playlist, QString newname);
  void notifyMovePlaylistTrack();

  void notifyNewMediumBasis(QList<MEDIUM> *list);
  void notifyNewMedium(MEDIUM *medium);
  void notifyMediumRemoved(int id);
  void notifyMediumAvailabilityChanged(int mediumID, QString path, bool avail);

  void clear();

  int getDisplayedPlaylistID();

  QListView*   getTracklist()   { return tracklist; }
  QSplitter*   getVsplit()   { return vsplit; }
  QListView*   getPlaylist_list()   { return playlist_list; }

 private:
  QListView *tracklist;
  QListView *current_tracklist;
  QListView *playlist_list;

  QList<QListViewItem> selectedItems;

  QPushButton *buttonNew, *buttonRename, *buttonRemove;
  QPushButton *buttonMoveUp, *buttonMoveDown;
  QSpinBox *generatorSpinTracks;
  QSpinBox *generatorSpinMinTrackLength;
  QSpinBox *generatorSpinMaxTrackLength;
  QComboBox *generatorComboArtists;
  QCheckBox *genaratorCheckBoxOnlyFavouriteArtists;    
  QFrame *pl_selframe;
  QFrame *tabGenerator;
  LVI_Playlist *displayed_playlist;

  QMap<int, LVI_PlaylistTrack*> mapCurrent;
  QMap<int, LVI_PlaylistTrack*> mapEditor;

  QMap<int, bool> mapAvail;
	QMap<int, int> mapType;
	QMap<int, QString> mapPath;

  bool isConnected;

  void getSelectedItems(bool current);
  bool existsPlaylist(const QString &s);

  QString adjustString(QString s);
  QSplitter *vsplit;

  bool firsttime;

 private slots:
  
  void slot_newButton();
  void slot_renameButton();
  void slot_removeButton();

  void slot_generateButton();
  void slot_resetButton();
  void slot_generatorMinTrackLength(int);
  void slot_generatorMaxTrackLength(int);

  void slot_movePlaylistTrackUp();
  void slot_movePlaylistTrackDown();
  void slot_savePlaylistTracks();
  void slot_menuPlaylistToSelection();

  void slot_contextMenu(QListViewItem *, const QPoint &, int);
  void slot_menuAddPlaylistToCurrent();
  void slot_menuRemovePlaylistTracks();

  void slot_menuPlayPlaylist();
  void slot_menuEnqueuePlaylist();
  void slot_menuBurnCD();

  void slot_menuPlayPlaylistTracks();
  void slot_menuEnqueuePlaylistTracks();

  void slot_playlistSelectionChanged(QListViewItem *);
  void slot_trackSelectionChanged();

  void slot_tabChange(QWidget *);

  void slot_playlistDoubleClicked(QListViewItem *lvi);
  void slot_playlistTrackDoubleClicked(QListViewItem *lvi);
};


class ExtendedDropListView : public QListView {
 public: 
  ExtendedDropListView(QWidget *parent=0, const char *name=0);
  
 protected:
  void dragEnterEvent(QDragEnterEvent* event);
  void dropEvent(QDropEvent* event);
};

#endif
